<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-user">
    <div class="b-head-user g-js">
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-head-user" mode="lego:content">
<xsl:variable name="url">
    <xsl:apply-templates select="." mode="lego:url-content"/>
</xsl:variable>
    <xsl:apply-templates select="lego:b-wc-status"/>
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-user url="{$url}" counter="{concat($lego:id, '.login.user')}">
                <xsl:value-of select="x:tolower($lego:params/lego:login)"/>
            </lego:b-user>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:b-head-user" mode="lego:url-content">
    <xsl:text>http://i.yandex.ru</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

