(function($, Lego){

Lego.block['b-hint-input'] = function(){
    var thisHintInput = $(this),
        input = $('#' + thisHintInput.attr('for')),
        hide = function(){ thisHintInput.hide() },
        show = function(){ thisHintInput.show() },
        check = function(){ focused || input.val()? hide() : show() },
        focused = false;

    input
        .focus(function(){ focused = true; check() }).blur(function(){ focused = false; check() })
        .bind('change mouseover', check);

    thisHintInput.click(function(){ input.focus() });

    input.change();

    // сами следим за изменением и генерируем событие,
    // нужно для всяких автоподстановщиков форм, которые не генерят события сами
    var oldValue = input.val();
    (function(){
        if (input.val() != oldValue) {
            $(input).trigger('change');
            oldValue = input.val();
        }
        setTimeout(arguments.callee, 200);
    })();
};

})(jQuery, window.Lego);
