/**
 * jQuery plugin for handling text insertion/deletion at caret position
 * Adopted from http://img.yandex.net/i/keyboardu.js
 */
jQuery.fn.extend({

    /**
     * Сохраняет позицию курсора в data.('caretPosition')
     */
    saveCaretPos: function() {
        var end,
            start,
            target = this.get(0),
            range;

        if (target.createTextRange) { //IE
            range = document.selection.createRange().duplicate();
            range.moveEnd('character', target.value.length);
            if (range.text == '') {
                start = target.value.length;
            } else {
                start = target.value.lastIndexOf(range.text);
            }

            range = document.selection.createRange().duplicate();
            range.moveStart('character', -target.value.length);
            end = range.text.length;

        } else if (target.setSelectionRange) {
            start =  target.selectionStart;
            end = target.selectionEnd
        } else {
            start = end = target.value.length;
        }

        if (start >= 0 && end >= 0) {
            this.data('selection', {
                'start': start,
                'end': end
            });
        }
    },

    setCaretPos: function(position) {
        var target = this.get(0);

        if (position >= 0) {
            this.data('selection', {
                'start': position,
                'end': position
            });
        } else {
            position = this.data('selection');
            if (position) {
                position = position.start;
            } else {
                return;
            }
        }

        if (target.setSelectionRange) {
            target.focus();
            target.setSelectionRange(position, position);

        } else if (target.createTextRange) { //IE
            var range = target.createTextRange();
            range.collapse(true);
            range.moveEnd('character', position);
            range.moveStart('character', position);
            range.select();
        }
    },

    insertAtCaretPos: function(key) {
        var caretPosition = this.data('selection'),
            targetField = this.get(0),
            newCaretPosition = caretPosition.start + key.length;

        targetField.value = targetField.value.substring(0, caretPosition.start) + key + targetField.value.substring(caretPosition.end);

        // для ИЕ каретка возвращает через timeout, поэтому тут ее ставить не надо
        if ($.browser.msie) {
            this.data('selection', {
                'start': newCaretPosition,
                'end': newCaretPosition
            });
        } else {
            this.setCaretPos(newCaretPosition);
        }

    },

    deleteAtCaretPos: function() {
        var caretPosition = this.data('selection'),
            targetField = this.get(0),
            newCaretPosition;

        if (caretPosition.start === caretPosition.end) {
            targetField.value = targetField.value.substring(0, caretPosition.start - 1) + targetField.value.substring(caretPosition.end);
            newCaretPosition = caretPosition.start - 1;
            if (newCaretPosition < 0) {
                newCaretPosition = 0;
            }
        } else {
            targetField.value = targetField.value.substring(0, caretPosition.start) + targetField.value.substring(caretPosition.end);
            newCaretPosition = caretPosition.start;
        }

        if ($.browser.msie) {
            this.data('selection', {
                'start': newCaretPosition,
                'end': newCaretPosition
            });
        } else {
            this.setCaretPos(newCaretPosition);
        }

    }
});