<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input/lego:precise">
    <xsl:apply-templates select="$lego:params/lego:b-search/lego:input[not(@name != current()/../@name)]/lego:precise"/>
</xsl:template>

<xsl:template match="/lego:b-search/lego:input/lego:precise">
    <span class="b-search__precise">
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input/lego:precise" mode="lego:content">
<xsl:variable name="id">
    <xsl:apply-templates select="." mode="lego:auto-id-content"/>
</xsl:variable>
<xsl:variable name="type">
    <xsl:choose>
        <xsl:when test="@type = 'radio'">radio</xsl:when>
        <xsl:otherwise>checkbox</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
    <label for="{$id}" class="b-search__precise-label">
        <input id="{$id}" class="b-search__precise-check" type="{$type}" tabindex="1">
            <xsl:apply-templates select="." mode="lego:class"/>
            <xsl:apply-templates select="." mode="lego:input-attributes"/>
            <xsl:apply-templates select="." mode="lego:onclick"/>
            <xsl:apply-templates select="@checked | @disabled" mode="lego:copy"/>
        </input>
        <xsl:apply-templates mode="lego:copy"/>
    </label>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

