<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input/lego:sample">
    <xsl:apply-templates select="$lego:params/lego:b-search/lego:input[not(@name != current()/../@name)]/lego:sample"/>
</xsl:template>

<xsl:template match="/lego:b-search/lego:input/lego:sample">
    <div class="b-search__sample g-js">
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:label"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-search/lego:input/lego:sample" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:variable name="name">
        <xsl:apply-templates select="ancestor::lego:input" mode="lego:name-content"/>
    </xsl:variable>

    <xsl:if test="$name and $name != $lego:b-search-default-input-name">
        <xsl:text>,'for':</xsl:text><xsl:value-of select="x:js-quote($name)"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input/lego:sample" mode="lego:label">
    <i class="b-search__intro">
        <xsl:apply-templates select="." mode="lego:label-content"/>
    </i>
    <xsl:text>&#160;</xsl:text>
</xsl:template>

<xsl:template match="lego:b-search/lego:input/lego:sample" mode="lego:label-content">
    <xsl:value-of select="lego:message('b-search-for-example', 'Например')"/>
    <xsl:text>,</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input/lego:sample" mode="lego:content">
    <xsl:call-template name="lego:b-pseudo-link">
        <xsl:with-param name="url">
            <xsl:apply-templates select="." mode="lego:url-content"/>
        </xsl:with-param>
        <xsl:with-param name="content" select="."/>
        <xsl:with-param name="counter">
            <xsl:apply-templates select="." mode="lego:counter-content"/>
        </xsl:with-param>
    </xsl:call-template>    
</xsl:template>

<xsl:template match="lego:b-search/lego:input/lego:sample" mode="lego:counter-content">
    <xsl:value-of select="$lego:id"/><xsl:text>.search.sample</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

