<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    exclude-result-prefixes="lego"
    >

    <xsl:template match="lego:b-tags"/>
    <xsl:template match="lego:b-tags[lego:tag]">
        <div>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="lego:title"/>
            <ul>
                <xsl:apply-templates select="lego:tag"/>
            </ul>
            <xsl:apply-templates select="lego:more"/>
        </div>
    </xsl:template>

    <xsl:template match="lego:b-tags/lego:title">
        <h3>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates/>
        </h3>
    </xsl:template>

    <xsl:template match="lego:b-tags//lego:tag">
        <li>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates/>
        </li>
        <xsl:text> </xsl:text>
    </xsl:template>

    <xsl:template match="lego:b-tags//lego:tag/lego:text" mode="lego:class-content">
        <xsl:text>b-tags__text</xsl:text>
    </xsl:template>

    <xsl:template match="lego:b-tags//lego:tag/lego:link" mode="lego:class-content">
        <xsl:text>b-tags__link</xsl:text>
    </xsl:template>

    <xsl:template match="lego:b-tags/lego:more">
        <div>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates/>
        </div>
    </xsl:template>

    <xsl:template match="lego:b-tags//lego:link">
        <a>
            <xsl:apply-templates select="." mode="lego:attributes"/>
            <xsl:apply-templates/>
        </a>
    </xsl:template>

    <xsl:template match="lego:b-tags//lego:link" mode="lego:attributes">
        <xsl:apply-imports/>
        <xsl:apply-templates select="." mode="lego:url"/>
    </xsl:template>

    <xsl:template match="lego:b-tags//lego:text">
        <span>
            <xsl:apply-templates select="." mode="lego:attributes"/>
            <xsl:apply-templates/>
        </span>
    </xsl:template>

    <xsl:template match="lego:b-tags/lego:more/lego:link" mode="lego:class-content">
        <xsl:text>b-tags__more-link</xsl:text>
    </xsl:template>

</xsl:stylesheet>
