<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:x="http://www.yandex.ru/xscript"
    exclude-result-prefixes=" lego x "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-userpic">
    <a href="http://i.yandex.ru/?avatar">
        <xsl:apply-templates select="." mode="lego:block-class"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

<xsl:template match="lego:b-userpic" mode="lego:content">
    <img class="b-userpic__img" alt="" onerror="this.style.display = 'none'">
        <xsl:apply-templates select="." mode="lego:src"/>
    </img>
    <i class="b-userpic__i"></i>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-userpic[@url]" mode="lego:url-content">
    <xsl:value-of select="@url"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-userpic" mode="lego:src-content">
    <xsl:text>//upics.yandex.net/get/</xsl:text>
    <xsl:choose>
        <xsl:when test="@login"><xsl:value-of select="@login"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="x:tolower($lego:params/lego:login)"/></xsl:otherwise>
    </xsl:choose>
    <xsl:if test="@lego:type">
        <xsl:text>/</xsl:text><xsl:value-of select="@lego:type"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:b-userpic">
<xsl:param name="url" select="'http://i.yandex.ru/?avatar'"/>
<xsl:param name="login" select="$lego:params/lego:login"/>
<xsl:param name="type" select="'middle'"/>
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-userpic url="{$url}" login="{$login}" lego:type="{$type}"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

