<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-wc-status"/>
<xsl:template match="lego:b-wc-status[lego:auth()]">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-wc-status" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-wc-status" mode="lego:content">
    <i class="b-wc-status__marker"/>
    <div class="b-wc-status__popup">
        <iframe class="b-wc-status__iframe" frameborder="0"/>
        <i class="b-wc-status__marker"/>
        <i class="b-wc-status__tail"/>
        <ul class="b-wc-status__list">
            <xsl:apply-templates select="lego:item"/>
        </ul>
    </div>
</xsl:template>

<xsl:template match="lego:b-wc-status/lego:item">
    <li class="b-wc-status__item">
        <xsl:apply-templates select="." mode="lego:content"/>
    </li>
</xsl:template>

<xsl:template match="lego:b-wc-status//lego:link">
    <a class="b-wc-status__link">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

<xsl:template match="lego:b-wc-status//lego:text">
    <xsl:call-template name="lego:b-pseudo-link">
        <xsl:with-param name="content" select="."/>
        <xsl:with-param name="class" select="'b-wc-status__link c-toggle'"/>
    </xsl:call-template>
</xsl:template>

</xsl:stylesheet>

