<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:math="http://exslt.org/math"
    exclude-result-prefixes=" x lego math "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="*" mode="lego:attributes">
    <xsl:apply-templates select="." mode="lego:id"/>
    <xsl:apply-templates select="." mode="lego:class"/>
</xsl:template>

<xsl:template match="lego:link" mode="lego:attributes">
    <xsl:apply-templates select="." mode="lego:id"/>
    <xsl:apply-templates select="." mode="lego:class"/>
    <xsl:copy-of select="@target"/>
</xsl:template>

<xsl:template match="*" mode="lego:block-attributes">
    <xsl:apply-templates select="." mode="lego:block-class"/>
</xsl:template>

<xsl:template match="*" mode="lego:form-attributes">
    <xsl:apply-templates select="." mode="lego:action"/>
    <xsl:apply-templates select="." mode="lego:method"/>
    <xsl:apply-templates select="." mode="lego:onsubmit"/>
</xsl:template>

<xsl:template match="*" mode="lego:input-attributes">
    <xsl:apply-templates select="." mode="lego:type"/>
    <xsl:apply-templates select="." mode="lego:name"/>
    <xsl:apply-templates select="." mode="lego:value"/>
    <xsl:apply-templates select="." mode="lego:tabindex"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:attribute-if-content">
<xsl:param name="name"/>
<xsl:param name="content"/>
    <xsl:variable name="normalized-content" select="normalize-space($content)"/>
    <xsl:if test="$normalized-content != ''">
        <xsl:call-template name="lego:attribute">
            <xsl:with-param name="name" select="$name"/>
            <xsl:with-param name="content" select="$normalized-content"/>
        </xsl:call-template>
    </xsl:if>
</xsl:template>

<xsl:template name="lego:attribute">
    <xsl:param name="name"/>
    <xsl:param name="content"/>
    <xsl:variable name="normalized-content" select="normalize-space($content)"/>
    <xsl:attribute name="{$name}">
        <xsl:value-of select="$normalized-content"/>
    </xsl:attribute>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="* | @*" mode="lego:id">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'id'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:id-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="* | @*" mode="lego:id-content"/>

<xsl:template match="*[@id]" mode="lego:id-content">
    <xsl:value-of select="@id"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:auto-id">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'id'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:auto-id-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:auto-id-content">
    <xsl:value-of select="generate-id()"/>
</xsl:template>

<xsl:template match="lego:*[@id]" mode="lego:auto-id-content">
    <xsl:value-of select="@id"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="*" mode="lego:block-class">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'class'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:block-class-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="*" mode="lego:block-class-content">
    <xsl:variable name="name" select="lego:name(.)"/>
    <xsl:variable name="class">
        <xsl:value-of select="$name"/>
        <xsl:for-each select="@*[namespace-uri() = 'https://lego.yandex-team.ru']">
            <xsl:value-of select="concat(' ', $name, '_')"/>
            <xsl:apply-templates select="." mode="lego:class-modifier"/>
        </xsl:for-each>
        <xsl:apply-templates select="." mode="lego:block-class-js"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="." mode="lego:class-content"/>
    </xsl:variable>
    <xsl:value-of select="normalize-space($class)"/>
</xsl:template>

<xsl:template match="*" mode="lego:block-class-js"/>

<!-- ############################################################################################################## -->

<xsl:template match="* | @*" mode="lego:class">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'class'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:class-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="* | @*" mode="lego:class-content"/>

<xsl:template match="*[@class]" mode="lego:class-content">
    <xsl:value-of select="@class"/>
</xsl:template>

<xsl:template match="@*" mode="lego:class-modifier">
    <xsl:value-of select="local-name()"/>
</xsl:template>

<xsl:template match="@*[. != '']" mode="lego:class-modifier">
    <xsl:value-of select="."/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="* | @*" mode="lego:url">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'href'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:url-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="* | @*" mode="lego:url-content"/>

<xsl:template match="*[@url]" mode="lego:url-content">
    <xsl:value-of select="@url"/>
</xsl:template>

<!-- ############################################################################################################## -->

<!-- You're lucky! -->
<xsl:variable name="lego:show-counters" select="floor(math:random() * 10) = 7"/>

<xsl:template match="lego:*" mode="lego:counter">
    <xsl:if test="$lego:show-counters">
        <xsl:variable name="counter">
            <xsl:apply-templates select="." mode="lego:counter-content"/>
        </xsl:variable>
        <xsl:if test="$counter">
            <xsl:variable name="event">
                <xsl:apply-templates select="." mode="lego:counter-event"/>
            </xsl:variable>
            <xsl:attribute name="{$event}">
                <xsl:text>Lego.ch(</xsl:text>
                <xsl:value-of select="x:js-quote($counter)"/>
                <xsl:text>,this)</xsl:text>
            </xsl:attribute>
        </xsl:if>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:*" mode="lego:counter-content">
    <xsl:value-of select="@counter"/>
</xsl:template>

<xsl:template match="lego:*" mode="lego:counter-event">
    <xsl:text>onmousedown</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:onclick">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'onclick'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:onclick-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:onclick-content"/>

<xsl:template match="lego:*[@onclick]" mode="lego:onclick-content">
    <xsl:value-of select="@onclick"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:action">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'action'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:action-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:action-content"/>

<xsl:template match="lego:*[@action]" mode="lego:action-content">
    <xsl:value-of select="@action"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:method">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'method'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:method-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:method-content"/>

<xsl:template match="lego:*[@method]" mode="lego:method-content">
    <xsl:value-of select="@method"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:onsubmit">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'onsubmit'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:onsubmit-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:onsubmit-content"/>

<xsl:template match="lego:*[@onsubmit]" mode="lego:onsubmit-content">
    <xsl:value-of select="@onsubmit"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:type">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'type'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:type-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:type-content"/>

<xsl:template match="lego:*[@type]" mode="lego:type-content">
    <xsl:value-of select="@type"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:name">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'name'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:name-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:name-content"/>

<xsl:template match="lego:*[@name]" mode="lego:name-content">
    <xsl:value-of select="@name"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:value">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'value'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:value-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:value-content"/>

<xsl:template match="lego:*[@value]" mode="lego:value-content">
    <xsl:value-of select="@value"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:tabindex">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'tabindex'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:tabindex-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:tabindex-content"/>

<xsl:template match="lego:*[@tabindex]" mode="lego:tabindex-content">
    <xsl:value-of select="@tabindex"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:src">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'src'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:src-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:src-content"/>

<xsl:template match="lego:*[@src]" mode="lego:src-content">
    <xsl:value-of select="@src"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:alt">
    <xsl:attribute name="alt">
        <xsl:apply-templates select="." mode="lego:alt-content"/>
    </xsl:attribute>
</xsl:template>

<xsl:template match="lego:*" mode="lego:alt-content"/>

<xsl:template match="lego:*[@alt]" mode="lego:alt-content">
    <xsl:value-of select="@alt"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:content">
    <xsl:apply-templates/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:js-params">
    <xsl:attribute name="onclick">
        <xsl:text>return {</xsl:text>
        <xsl:apply-templates select="." mode="lego:js-params-content"/>
        <xsl:text>}</xsl:text>
    </xsl:attribute>
</xsl:template>

<xsl:template match="lego:*" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(lego:name(.))"/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

