<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:item">
    <td>
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </td>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:item" mode="lego:content">
    <xsl:apply-templates select="." mode="lego:current"/>
</xsl:template>

<xsl:template match="lego:item" mode="lego:current">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="lego:item[@current]" mode="lego:current">
    <strong>
        <xsl:apply-templates/>
    </strong>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:item//lego:link">
    <a>
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:counter"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:item//lego:button">
    <button>
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:input-attributes"/>
        <xsl:apply-templates select="." mode="lego:counter"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </button>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:item//lego:text">
    <span>
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:item//lego:html">
    <xsl:apply-templates select="." mode="lego:content"/>
</xsl:template>

<xsl:template match="lego:item//lego:html" mode="lego:content">
    <xsl:apply-templates mode="lego:copy"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:item//lego:image">
    <img alt="">
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:src"/>
        <xsl:apply-templates select="." mode="lego:alt"/>
    </img>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

