<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:str="http://exslt.org/strings"
    xmlns:exsl="http://exslt.org/common"
    xmlns:func="http://exslt.org/functions"
    exclude-result-prefixes=" lego str exsl func "
    extension-element-prefixes=" str exsl func "
    version="1.0">

<!-- ############################################################################################################## -->

<!-- Пример использования:

    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-pager current-page="17" total-count="403" page-url="/search.xml?text=blah"/>
        </xsl:with-param>
    </xsl:call-template>

-->

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-pager">
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-pager perpage-count="20" page-url="" page-param="p" start-from="0" pager-radius="7">
                <xsl:copy-of select="@* | *"/>
                <lego:with-defaults/> <!-- Magic! Do not touch. -->
            </lego:b-pager>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:b-pager[lego:with-defaults]">
<xsl:variable name="total-pages" select="ceiling(@total-count div @perpage-count)"/>
<xsl:variable name="current-page">
    <xsl:choose>
        <xsl:when test="@current-page != ''"><xsl:value-of select="@current-page + (1 - @start-from)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="1"/></xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="left-page" select="lego:max(1, $current-page - @pager-radius)"/>
<xsl:variable name="right-page" select="lego:min($total-pages, $current-page + @pager-radius)"/>
<xsl:variable name="this" select="."/>

    <xsl:variable name="pager-xml">
        <xsl:if test="$total-pages &gt; 1">
            <lego:b-pager>
                <lego:title><xsl:value-of select="lego:message('b-pager-pages', 'Страницы')"/></lego:title>

                <lego:prev>
                    <xsl:if test="$current-page &gt; 1">
                        <xsl:attribute name="url"><xsl:value-of select="lego:b-pager-url($current-page - 1)"/></xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="lego:message('b-pager-prev', 'предыдущая')"/>
                </lego:prev>
                <lego:next>
                    <xsl:if test="$current-page &lt; $total-pages">
                        <xsl:attribute name="url"><xsl:value-of select="lego:b-pager-url($current-page + 1)"/></xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="lego:message('b-pager-next', 'следующая')"/>
                </lego:next>

                <lego:pages>
                    <xsl:if test="$left-page &gt; 1">
                        <lego:more url="{lego:b-pager-url($left-page - 1)}">&#8230;</lego:more>
                    </xsl:if>
                    <xsl:for-each select="str:tokenize( str:padding($right-page - $left-page + 1, '.'), '' )">
                        <xsl:variable name="i" select="$left-page + position() - 1"/>
                        <xsl:for-each select="$this">
                            <lego:page>
                                <xsl:choose>
                                    <xsl:when test="$i = $current-page"><xsl:attribute name="current">current</xsl:attribute></xsl:when>
                                    <xsl:otherwise><xsl:attribute name="url"><xsl:value-of select="lego:b-pager-url($i)"/></xsl:attribute></xsl:otherwise>
                                </xsl:choose>
                                <xsl:value-of select="$i"/>
                            </lego:page>
                        </xsl:for-each>
                    </xsl:for-each>
                    <xsl:if test="$right-page &lt; $total-pages">
                        <lego:more url="{lego:b-pager-url($right-page + 1)}">&#8230;</lego:more>
                    </xsl:if>
                </lego:pages>
                <xsl:apply-templates select="lego:sorted" mode="lego:xml"/>
            </lego:b-pager>
        </xsl:if>
    </xsl:variable>
    <xsl:apply-templates select="exsl:node-set($pager-xml)" mode="lego:html"/>

</xsl:template>

<xsl:template match="lego:sorted" mode="lego:xml">
    <lego:sorted>
        <xsl:copy-of select="lego:text"/>
        <xsl:apply-templates select="lego:item" mode="lego:xml"/>
    </lego:sorted>
</xsl:template>

<xsl:template match="lego:sorted/lego:item" mode="lego:xml">
    <xsl:copy-of select="."/>
</xsl:template>
<xsl:template match="lego:item[not(@lego:selected)]" mode="lego:xml">
    <lego:item url="{lego:b-pager-url('0', @name)}">
        <xsl:copy-of select="node()"/>
    </lego:item>
</xsl:template>

<!-- ############################################################################################################## -->

<func:function name="lego:b-pager-url">
    <xsl:param name="page-num"/>
    <xsl:param name="sorted" select="false()"/>
    <func:result>
        <xsl:variable name="page-url" select="ancestor-or-self::lego:b-pager/@page-url"/>
        <xsl:value-of select="$page-url"/>
        <xsl:if test="$page-num &gt; 1 or $sorted">
            <xsl:choose>
                <xsl:when test="contains($page-url, '?')">&amp;</xsl:when>
                <xsl:otherwise>?</xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="$page-num &gt; 1">
                <xsl:value-of select="concat(@page-param, '=', $page-num - (1 - @start-from))"/>
            </xsl:when>
            <xsl:when test="$sorted">
                <xsl:value-of select="concat('sorted', '=', @name)"/>
            </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
        <xsl:if test="ancestor-or-self::lego:b-pager/@anchor">
            <xsl:text>#</xsl:text>
            <xsl:value-of select="ancestor-or-self::lego:b-pager/@anchor"/>
        </xsl:if>
    </func:result>
</func:function>

<!-- ############################################################################################################## -->

<!-- для вывода реального html'я нужно написать xsl-шкурку, переопределяющую этот шаблон -->
<xsl:template match="lego:b-pager" mode="lego:html">
    <xsl:copy-of select="."/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

