(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Счётчик клика на ссылку или просто показа.
 *
 * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
 *
 * В случае учёта показа динамически создаёт скрипт с URL системы учёта.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onmousedown="Lego.c('stred/pid=7/cid=433',this)">Гидрометцентр</a>
 *
 * или
 *
 * <script type="text/javascript">Lego.c('stred/pid=7/cid=433')</script>
 *
 * @param w     параметры счётчика
 * @param a     (optional) ссылка, клик на которую надо учитывать
 */ /**/
Lego.c = function(w, a) {
/*
    new Image().src = location.protocol + '//clck.yandex.ru/click/dtype=' + w +
        '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
        '/*' + (a ? (a.href || location.href) : '');
*/

    var url = function(w, h, t) {
        return location.protocol + '//clck.yandex.ru/' + t + '/dtype=' + w +
                '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
                '/*' + (h.match(/^http/) ? h : location.protocol + '//' + location.host + (h.match('^/') ? h : '/' + h));
    }

    var click = function() {
        var head = document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0];
        var script = document.createElement('script');
        script.setAttribute('src', url(w, location.href, 'jclck'));
        head.insertBefore(script, head.firstChild);
    }

    if (a) {
        if (a.className.match(/b-pseudo-link/)) { // для псевдоссылки просто считаем click, создавая iframe и в него грузим счётчик
            click();
        } else if (a.href) { // клик на ссылку, подменяем href на redir'овский, потом по таймауту обратно
            var h = a.href;
            a.href = url(w, h, "redir");
            setTimeout(function() { a.href = h }, 500);
        } else if (a.form) { // клик на элемент формы
            if (a.type.match(/submit|button|image/)) { // клик на кнопку, подменяем action на redir'овский, потом по таймауту обратно
                var h = a.form.action;
                a.form.action = url(w, h, "redir");
                setTimeout(function() { a.form.action = h }, 500);
            } else { // просто считаем click, создавая iframe и в него грузим счётчик
                click();
            }
        } else if (a.action) { //случай сабмита формы - подменяем его action на redir'овский, назад нам его менять не нужно
            a.action = url(w, a.action, "redir");
        } else {
            throw "counter.js: not link and not form!";
        }
    } else { // ссылки нет, просто учёт показа, создаём iframe и в него грузим счётчик
        click();
    }
}

})(window.Lego);
