(function($, Lego) {

    Lego.block['b-user-list'] = function(params) {

        if (!params.edit) return;
        
        var block = $(this),
            input = $('.b-user-list__input',this),
            output = $('.b-user-list__output',this),
            list = $('.b-user-list__list',this),
            sample = $('.b-user-list__sample',this),
            spin = $('.b-user-list__spin',this),
            errorblock = $('.b-user-list__error',this),

            ajaxhandler = params.ajaxhandler;

        // Перехватываем ENTER в форме
        // Если нажать ENTER до появления автокомплита, сабмитится форма
        $(this).keypress(function(e){
            if (e.keyCode == 13) {
                e.stopPropagation();
                e.preventDefault();
                if (input.val()) errorblock.text('Такого сотрудника не существует'); else errorblock.text(''); 
            }
        })

        // Ждем появления $.staffAutocomplete
        if(input.length) {
            var interval = setInterval(function(){
                if ($.fn.staffAutocomplete){
                    clearInterval(interval);
                    input.staffAutocomplete({result:addHandler, is_dismissed:true});
                };
            },500);
            
            $(".b-user-list__del",this).click(removeHandler)
        }

        function addHandler(user) {
            //Если был выведн текст об ошибке - скрываем
            errorblock.text('');

            //Проверяем есть ли пользователь уже в списке
            if(output.val().search(new RegExp("\\b" + user.login_ld + "\\b")) < 0) {
                if (ajaxhandler) {
                    $.ajax({
                        url: ajaxhandler,
                        data: {
                            action: 'add',
                            user: user.login_ld
                        },
                        dataType: 'json',
                        type: 'POST',
                        success: function(data) {
                            if (data.success) {
                                addUserToList(user);
                            } else {
                                var errormsg = data.error || 'Сотрудник не добавлен!';
                                errorblock.text(errormsg);
                            }
                            spin.addClass('g-hidden');
                        },
                        error: function(request,error){
                            if (error) errorblock.text('Ошибка. ' + error);
                        }
                    });
                    spin.removeClass('g-hidden');
                } else {
                    addUserToList(user);
                }
            }
            input.val("");
        }

        function removeHandler() {
            if (params.confirmdelete) if (!confirm('Удалить сотрудника из списка?')) return; 

            var parentnode = $(this).parent();
            errorblock.text('');

            if (ajaxhandler) {
                $.ajax({
                    url: ajaxhandler,
                    data: {
                        action: 'delete',
                        user: parentnode.find('.b-user__link').attr('lang')
                    },
                    dataType: 'json',
                    type: 'POST',
                    success: function(data) {
                        if (data.success) {
                            removeUserFromList(parentnode);
                        } else {
                            var errormsg = data.error || 'Сотрудник не был удален!'; 
                            errorblock.text(errormsg);
                        }
                        spin.addClass('g-hidden');
                    },
                    error: function(request,error){
                        if (error) errorblock.text('Ошибка. ' + error);
                    }
                });
                spin.removeClass('g-hidden');
            } else {
                removeUserFromList(parentnode);
            }
        }

        function addUserToList(user) {
            var node = sample.clone().removeClass("b-user-list__sample g-hidden");
            node.find(".b-user__link")
                    .removeClass('auto-person-card-fixed')
                    .html('<b class="b-user__first-letter">' + user.first_name.substr(0,1) + '</b>' + user.first_name.substr(1) + ' ' + user.last_name)
                    .attr({
                        lang: user.login_ld,
                        href: "http://staff.yandex-team.ru/" + user.login_ld
                     });
            node.find(".b-user-list__del").click(removeHandler);
            list.prepend(node);
            output.val(output.val() + " " + user.login_ld);
            output.trigger('change');

            // Инициализация карточек
            if (document.PersonCard) document.PersonCard.auto();
        }

        function removeUserFromList(userNode) {
            var login = userNode.find('.b-user__link').attr('lang');
            output.val(output.val().replace(new RegExp("\\b" + login + "\\b"),""));
            userNode.remove();
            output.trigger('change');
            block.trigger('userdeleted',[login]);
        }
    }
    
})(jQuery, window.Lego);
