<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes="lego"
    version="1.0">

<xsl:variable name="dep_prefix"><xsl:value-of select="//lego:b-yandex-tree/@department_prefix"/></xsl:variable>
<xsl:variable name="ser_prefix"><xsl:value-of select="//lego:b-yandex-tree/@service_prefix"/></xsl:variable>
<xsl:variable name="usr_prefix"><xsl:value-of select="//lego:b-yandex-tree/@user_prefix"/></xsl:variable>
<xsl:variable name="dep_selected"><xsl:value-of select="//lego:b-yandex-tree/@department"/></xsl:variable>
<xsl:variable name="ser_selected"><xsl:value-of select="//lego:b-yandex-tree/@service"/></xsl:variable>
<xsl:variable name="wik_selected"><xsl:value-of select="//lego:b-yandex-tree/@wiki"/></xsl:variable>
<xsl:variable name="tab_selected"><xsl:value-of select="1"/></xsl:variable>

<!-- ############################################################################################################## -->
<!-- Когда починят LEGO-1011 оторвать -->

<xsl:template match="lego:b-vmenu//lego:switcher">
    <span class="switcher">
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <i class="switcher-icon">
            <img alt="+" src="//lego.static.yandex.net/2.1/common/block/b-vmenu/switcher/b-vmenu.switcher.gif"/>
        </i>
        <xsl:apply-templates select="lego:*"/>
    </span>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-yandex-tree">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:call-template name="lego:apply">
            <xsl:with-param name="content">
                <lego:b-tabbed-pane>
                    <lego:tabs lego:type="horizontal">
                        <xsl:apply-templates select="dep[@id=3] | services | staff | intranet" mode="tab"/>
                    </lego:tabs>
                    <lego:panels>
                        <xsl:apply-templates select="dep[@id=3] | services | staff | intranet" mode="panel"/>
                    </lego:panels>
                </lego:b-tabbed-pane>
            </xsl:with-param>
        </xsl:call-template>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="dep | services | staff | intranet" mode="tab">
    <lego:tab bind="{name()}">
        <xsl:if test="position() = $tab_selected">
            <xsl:attribute name="lego:type">
                <xsl:text> b-tabbed-pane__item_current</xsl:text>
            </xsl:attribute>
        </xsl:if>
        <xsl:call-template name="lego:apply">
            <xsl:with-param name="content">
                <lego:b-pseudo-link>
                    <xsl:apply-templates select="." mode="tabname"/>
                </lego:b-pseudo-link>
            </xsl:with-param>
        </xsl:call-template>
    </lego:tab>
</xsl:template>

<xsl:template match="dep" mode="tabname">
    <xsl:text>Отделы и департаменты</xsl:text>
</xsl:template>

<xsl:template match="services" mode="tabname">
    <xsl:text>Сервисы</xsl:text>
</xsl:template>

<xsl:template match="staff" mode="tabname">
    <xsl:text>Сотрудники</xsl:text>
</xsl:template>

<xsl:template match="intranet" mode="tabname">
    <xsl:text>Вики-группы</xsl:text>    
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="dep | services | intranet | staff"  mode="panel">
    <lego:panel id="{name()}">
        <xsl:if test="position()=$tab_selected">
            <xsl:attribute name="current">yes</xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="." mode="search"/>
        <xsl:apply-templates select="." mode="tree"/>
        <xsl:apply-templates select="newgroup" />
    </lego:panel>
</xsl:template>

<xsl:template match="intranet" mode="search" />

<xsl:template match="dep | services | intranet[@search] | staff"  mode="search">
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-icon-intranet lego:type="cancel b-yandex-tree__cancel g-hidden js-yandex-tree__cancel"/>
        </xsl:with-param>
    </xsl:call-template>
    <div class="b-input">
        <label class="b-hint-input g-js" for="b-yandex-tree__{name()}_search" style="display: block;">
            <xsl:attribute name="onclick">return {name:'b\-hint\-input'}</xsl:attribute>
            <xsl:apply-templates select="." mode="hint"/>
        </label>
        <xsl:apply-templates select="." mode="searchinput"/>
    </div>
</xsl:template>

<xsl:template match="dep | services | intranet" mode="searchinput">
    <input name="text" id="b-yandex-tree__{name()}_search" class="g-js b-input__text">
        <xsl:attribute name="onclick">
            <xsl:text>return {name:'b\-search__input',focus:false}</xsl:text>
        </xsl:attribute>
    </input>
</xsl:template>

<xsl:template match="staff" mode="searchinput">
    <input name="text" id="b-yandex-tree__{name()}_search" class="g-js b-input__text js-suggest_staff">
        <xsl:attribute name="onclick"><xsl:text>return {name:'b\-search__input',focus:false,url:'</xsl:text>
            <xsl:value-of select="$usr_prefix"/>
            <xsl:text>'}</xsl:text>
        </xsl:attribute>
    </input>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="dep" mode="hint">
    <xsl:text>поиск депаратмента</xsl:text>
</xsl:template>

<xsl:template match="services" mode="hint">
    <xsl:text>поиск сервиса</xsl:text>
</xsl:template>

<xsl:template match="staff" mode="hint">
    <xsl:text>поиск сотрудника</xsl:text>
</xsl:template>

<xsl:template match="intranet" mode="hint">
    <xsl:text>поиск группы</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="*" mode="tree">
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-vmenu lego:size="120" lego:style="round" lego:theme="bbccf3">
                <xsl:apply-templates select="dep | service | group" mode="item" />
            </lego:b-vmenu>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="dep[dep] | service[service] | group[group]" mode="item">
    <lego:item>
        <xsl:variable name="selectedChildren"><xsl:value-of select="count(.//dep[@id = $dep_selected] | .//service[@id = $ser_selected] | .//group[@id = $wik_selected])"/></xsl:variable>
        <lego:switcher>
            <xsl:if test="$selectedChildren != 0">
                <xsl:attribute name="class">
                    <xsl:text>switcher switcher-on</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="." mode="content"/>
        </lego:switcher>
        <lego:b-vmenu>
            <xsl:if test="$selectedChildren = 0">
                <xsl:attribute name="class">
                    <xsl:text> g-hidden</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="dep | service | group" mode="item">
                <xsl:sort select="@name" />
            </xsl:apply-templates>
        </lego:b-vmenu>
    </lego:item>
</xsl:template>

<xsl:template match="dep | service | group" mode="item">
    <lego:item>
        <xsl:apply-templates select="." mode="content"/>
    </lego:item>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="dep" mode="content">
    <xsl:choose>
        <xsl:when test="@id = $dep_selected">
            <xsl:apply-templates select="." mode="current"/>
        </xsl:when>

        <xsl:otherwise>
            <xsl:apply-templates select="." mode="link"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="service" mode="content">
    <xsl:choose>
        <xsl:when test="@id = $ser_selected">
            <xsl:apply-templates select="." mode="current"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates select="." mode="link"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="group" mode="content">
    <xsl:choose>
        <xsl:when test="@id = $wik_selected">
            <xsl:apply-templates select="." mode="current"/>
        </xsl:when>
        <!--
        <xsl:when test="@onclick">
            <lego:b-pseudo-link onclick="ss"><xsl:value-of select="@name"/></lego:b-pseudo-link>
        </xsl:when>
        -->
        <xsl:otherwise>
            <xsl:apply-templates select="." mode="link"/>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="string(.)">
        <lego:html>
            <div class="b-yandex-tree__groupdescr">
                <xsl:copy-of select="group"/>
            </div>
        </lego:html>
    </xsl:if>
</xsl:template>

<!-- ############################################################ -->

<xsl:template match="dep | service | group" mode="current">
    <lego:html>
        <span class="current">
            <i class="b-round b-round_2"><i class="l t"><i/></i><i class="r t"><i/></i></i>
            <strong><xsl:value-of select="@name | @dep_name"/></strong>
            <i class="b-round b-round_2"><i class="l b"><i/></i><i class="r b"><i/></i></i>
        </span>
    </lego:html>
</xsl:template>

<xsl:template match="dep | service | group" mode="link">
    <xsl:choose>
        <xsl:when test="@url">
            <xsl:call-template name="link">
                <xsl:with-param name="url" select="@url"/>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates select="." mode="build-link"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="*" mode="build-link" />

<xsl:template match="dep" mode="build-link">
    <xsl:call-template name="link">
        <xsl:with-param name="url" select="concat($dep_prefix,@id)"/>
    </xsl:call-template>
</xsl:template>

<xsl:template match="service" mode="build-link">
    <xsl:call-template name="link">
        <xsl:with-param name="url" select="concat($ser_prefix,@id)"/>
    </xsl:call-template>
</xsl:template>

<xsl:template name="link">
    <xsl:param name="url"/>
    <lego:link url="{$url}">
    <xsl:if test="@my">
        <xsl:attribute name="class">
            <xsl:text>b-yandex-tree__my</xsl:text>
        </xsl:attribute>
    </xsl:if>
    <xsl:value-of select="@name | @dep_name"/>
</lego:link>
</xsl:template>

<!-- ############################################################ -->

<xsl:template match="lego:b-yandex-tree/intranet/newgroup">
    <div class="b-yandex-tree__new">
        <xsl:call-template name="lego:apply">
              <xsl:with-param name="content">
                <xsl:copy-of select="." />
              </xsl:with-param>
        </xsl:call-template>
    </div>
</xsl:template>


</xsl:stylesheet>