package Paths::XSL;

use strict;
use Paths;
use Tools;

our(@ISA);

@ISA = qw( Paths );

sub _line {
    my ($self, $line) = @_;

    return qq|<xsl:import href="$line"/>\n|;
}

sub _header {
    my ($self) = @_;

    my $dots = Tools::dots($self->{params}->{output});

    my $result = <<XSL;
<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">

<!-- Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. -->
XSL
    return $result;
}

sub _footer {
    my ($self) = @_;

    my $output = $self->{options}->{'xsl-output'} || '';

    my $r = "\n";

    if ($output eq 'html') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="html"
    indent="no"
    media-type="text/html; charset=UTF-8"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    omit-xml-declaration="yes"
/>

XSL
    } elsif ($output eq 'json') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="text"
    indent="no"
    media-type="text/javascript; charset=UTF-8"
    omit-xml-declaration="yes"
/>

XSL
    }

    $r .= <<XSL;
</xsl:stylesheet>
XSL

    return $r;
}

1;

