<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:func="http://exslt.org/functions"
    xmlns:xi="http://www.w3.org/2001/XInclude"
    exclude-result-prefixes=" lego xi func "
    extension-element-prefixes=" func "
    version="1.0">

<xsl:include href="../common/block/i-metrika/i-metrika.convert2xml.xsl"/>
<xsl:include href="../common/block/b-statcounter/b-statcounter.convert2xml.xsl"/>

<xsl:output method="xml" indent="yes" encoding="utf-8"/>

<xsl:variable name="id" select="/lego:page/global/id"/>

<xsl:param name="locale" select="'ru'"/>

<xsl:variable name="services" select="document(concat('../common/block/i-services/common.', $locale, '.xml'))/lego:services/lego:service"/>
<xsl:variable name="messages" select="document(concat('../common/block/i-messages/messages.', $locale, '.xml'))/lego:messages/lego:message"/>

<!-- ############################################################################################################## -->

<xsl:template match="/">
    <xsl:comment> Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. </xsl:comment>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="lego:page">
    <xsl:copy>
        <lego:i-common/>
        <lego:i-global lego:type="{global/css-global}"/>
        <xsl:apply-templates select="." mode="content"/>

        <xsl:if test="global/need-localization">
            <lego:i-locale/>
        </xsl:if>
        <xsl:if test="$locale != 'ru'">
            <xi:include href="{concat('../../common/block/i-messages/messages.', $locale, '.xml')}"/>
        </xsl:if>
    </xsl:copy>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="*|@*">
    <xsl:copy>
        <xsl:apply-templates select="." mode="content"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="*|@*" mode="content">
    <xsl:apply-templates select="@*"/>
    <xsl:apply-templates select="*|text()"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-logo/lego:b-head-name | lego:b-head-line/lego:b-head-name">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:value-of select="lego:service-name()"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-head-tabs">
    <lego:b-head-tabs>
        <xsl:apply-templates select="@*"/>
        <xsl:apply-templates select="document(concat('../common/block/b-head-tabs/b-head-tabs.xml.', @type, '.', $locale, '.xml'))/lego:b-head-tabs/*"/>
    </lego:b-head-tabs>
</xsl:template>

<xsl:template match="lego:b-head-tabs//lego:item">
    <xsl:choose>
        <xsl:when test="@service-id = $id">
            <lego:item current="" service-id="{@service-id}">
                <xsl:apply-templates select="." mode="content"/>
            </lego:item>
        </xsl:when>
        <xsl:otherwise>
            <xsl:copy>
                <xsl:apply-templates select="@*"/>
                <xsl:apply-templates/>
            </xsl:copy>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot">
    <xsl:copy>
        <xsl:apply-templates select="@*"/>
        <lego:layout>
            <xsl:apply-templates/>
        </lego:layout>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-foot//lego:copyright">
    <lego:copyright>
        <xsl:apply-templates select="@*"/>
        <xsl:copy-of select="lego:service('www')/@url"/>
        <xsl:apply-templates/>
    </lego:copyright>
</xsl:template>

<xsl:template match="lego:b-head-tabs/@type"/>
<xsl:template match="lego:l-head/@id"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-logo">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:attribute name="url">
            <xsl:value-of select="lego:service('www')/@url"/>
        </xsl:attribute>
        <xsl:apply-templates/>
    </xsl:copy>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik | lego:b-auth-bigform">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates select="." mode="lego:title"/>
        <xsl:apply-templates select="." mode="lego:register"/>
        <lego:username>
            <lego:input name="login" type="text">
                <lego:hint>
                    <lego:b-hint-input>
                        <xsl:value-of select="$messages[@id = 'b-auth:login']"/>
                    </lego:b-hint-input>
                </lego:hint>
            </lego:input>
        </lego:username>
        <lego:password>
            <lego:input name="passwd" type="password">
                <lego:hint>
                    <lego:b-hint-input>
                        <xsl:value-of select="$messages[@id = 'b-auth:password']"/>
                    </lego:b-hint-input>
                </lego:hint>
            </lego:input>
        </lego:password>
        <lego:b-auth/>
        <xsl:if test="@lego:type = 'popup'">
            <lego:b-popup-under/>
        </xsl:if>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-auth-domik | lego:b-auth-bigform" mode="lego:title">
    <lego:title>
        <xsl:value-of select="lego:service-name()"/>
    </lego:title>
</xsl:template>

<xsl:template match="lego:b-auth-domik[lego:title] | lego:b-auth-bigform[lego:title]" mode="lego:title">
    <xsl:copy-of select="lego:title"/>
</xsl:template>

<xsl:template match="lego:b-auth-domik | lego:b-auth-bigform" mode="lego:register">
    <lego:register>
        <xsl:value-of select="$messages[@id = 'b-auth:register']"/>
    </lego:register>
</xsl:template>

<xsl:template match="lego:b-auth-domik[lego:register] | lego:b-auth-bigform[lego:register]" mode="lego:register">
    <xsl:copy-of select="lego:register"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-wc-status">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <lego:item>
            <lego:text>
                <xsl:value-of select="$messages[@id = 'b-wc-status:off']"/>
            </lego:text>
        </lego:item>
        <lego:item>
            <lego:link url="http://mail.yandex.ru/history">
                <xsl:value-of select="$messages[@id = 'b-wc-status:history']"/>
            </lego:link>
        </lego:item>
        <lego:item>
            <lego:link url="http://online.yandex.ru/">
                <xsl:value-of select="$messages[@id = 'b-wc-status:setup']"/>
            </lego:link>
        </lego:item>
        <lego:item>
            <lego:link url="http://online.yandex.ru/faq/">
                <xsl:value-of select="$messages[@id = 'b-wc-status:faq']"/>
            </lego:link>
        </lego:item>
    </xsl:copy>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:mobile[not(@url)]">
    <xsl:copy>
        <xsl:attribute name="url">
            <xsl:value-of select="concat('http://mobile.yandex.ru/?', $id)"/>
        </xsl:attribute>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </xsl:copy>
</xsl:template>

<!-- ############################################################################################################## -->

<!-- для мобильного лего -->

<xsl:template match="lego:page[global/mobile]/lego:b-foot">
    <xsl:copy>
        <xsl:copy-of select="lego:service()/@waplog-id"/>
        <xsl:apply-templates select="." mode="content"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:page[global/mobile]//lego:b-foot/lego:services">
    <lego:services>
        <xsl:copy-of select="document(concat('../common/xml/b-head-tabs/b-head-tabs.xml.', @type, '.', $locale, '.xml'))/lego:tabs"/>
    </lego:services>
</xsl:template>

<xsl:template match="lego:page[global/mobile]//lego:b-head/lego:name">
    <lego:name>
        <xsl:value-of select="lego:service-name()"/>
    </lego:name>
</xsl:template>

<!-- ############################################################################################################## -->

<func:function name="lego:service">
<xsl:param name="service-id" select="$id"/>
    <func:result select="$services[@id = $service-id]"/>
</func:function>

<func:function name="lego:service-name">
<xsl:param name="service-id" select="$id"/>
<xsl:variable name="service" select="$services[@id = $service-id]"/>
    <func:result>
        <xsl:choose>
            <xsl:when test="$service != ''">
                <xsl:value-of select="$service"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </func:result>
</func:function>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-keyboard-loader">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
        <lego:progress/>
        <lego:g-hidden/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-keyboard-loader/lego:flag">
    <xsl:copy>
        <lego:b-ico/>
    </xsl:copy>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

