<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<xsl:output method="text"/>

<!-- ############################################################################################################## -->

<xsl:variable name="cr"><xsl:text>
</xsl:text></xsl:variable>

<xsl:template match="/lego:*">
    <xsl:apply-templates select="lego:*"/>
</xsl:template>

<!-- ############################################################################################################## -->

<!-- вложенные блоки -->
<xsl:template match="lego:*">
<xsl:param name="name"/>
    <xsl:if test="$name">
        <xsl:value-of select="concat($name, '/', local-name(), '/', $name, '.', local-name(), $cr)"/>
        <xsl:value-of select="concat($name, '/', local-name(), '/', $name, '_', local-name(), $cr)"/>
    </xsl:if>
    <xsl:apply-templates select="lego:*">
        <xsl:with-param name="name" select="$name"/>
    </xsl:apply-templates>
</xsl:template>

<!-- независимые блоки -->
<xsl:template match="lego:*[translate(substring(local-name(), 1, 2), 'blegzi', '') = '-']">
    <xsl:value-of select="concat(local-name(), '/', local-name(), $cr)"/>
    <!-- сперва выводим вложенные блоки -->
    <xsl:apply-templates select="lego:*">
        <xsl:with-param name="name" select="local-name()"/>
    </xsl:apply-templates>
    <!-- затем модификаторы -->
    <xsl:apply-templates select="@*">
        <xsl:with-param name="name" select="local-name()"/>
    </xsl:apply-templates>
</xsl:template>

<xsl:template match="@*"/>

<!-- модификаторы -->
<xsl:template match="@*[namespace-uri() = 'https://lego.yandex-team.ru']">
<xsl:param name="name"/>
<xsl:variable name="value">
    <xsl:choose>
        <xsl:when test=". = ''"><xsl:value-of select="local-name()"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
    </xsl:choose>
</xsl:variable>
    <xsl:value-of select="concat($name, '/_', local-name(), '/', $name, '_', $value, $cr)"/>
    <xsl:value-of select="concat($name, '/_', local-name(), '/', $name, '__', $value, $cr)"/>
</xsl:template>

</xsl:stylesheet>

