FROM registry.yandex.net/tools/libra:2.5.0

EXPOSE 80
CMD uwsgi --ini=/uwsgiconf.ini

COPY deps/debian-build.txt /
COPY deps/debian-main.txt /
RUN apt-get -qq update \
    && cat debian-build.txt debian-main.txt | xargs apt-get -qq install -y \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/*

COPY deps/python-main.txt /
RUN pip install --disable-pip-version-check -i https://pypi.yandex-team.ru/simple/ -r python-main.txt

COPY media/ src/media

WORKDIR /src/media

RUN ycssjs \
    js/libra.js \
    css/libra*.css \
    js/libkiosk.js \
    css/libkiosk.css

WORKDIR /

COPY src/setup.py src/
COPY uwsgiconf.ini /
COPY src/libra/ src/libra/

RUN pip install /src/
