# -*- coding: utf-8 -*-
from django.conf import settings
from django.http import Http404, HttpResponse
from django.db.models import Q,Count, Sum
from django.shortcuts import render_to_response, get_object_or_404 #, redirect
from libra.shortcuts import response_json

from libra.books.models import BookItem
import csv
from datetime import datetime

def books_reg_count(request):
    # Возвращает количество регистраций книг в день за указанный период в формате CSV
    # get-параметр from - с какой даты показывать статистику, если не указана то с 12.11.2009 (дата импорта первых данных)
    # get-параметр to - по какую дату показывать статистику. Если не указано - то по текущий момент.
    # get-параметр owns: значения ya, pr или не указано. Фильтр по книгам компании, личным книгам, всем книгам.
    
    dt_from = request.GET.get('from','2009-11-12')
    dt_to = request.GET.get('to', datetime.now())
    
    ownership = request.GET.get('owns', None)
    
    books_stat = BookItem.objects.filter(reg_date__gte=dt_from, reg_date__lte=dt_to)
    
    if ownership:
        books_stat = books_stat.filter(ownership_choices = ownership.upper())
    
    books_stat = books_stat.extra(select={'reg_date2':"DATE(`reg_date`)"}).values('reg_date2').annotate(Count('id')).order_by('reg_date2')
    
    response = HttpResponse(mimetype = 'text/csv')
    response['Content-Disposition'] = 'attachment; filename = lib-statistics.csv'
    
    writer = csv.writer(response)
    for entry in books_stat:
        writer.writerow((entry['reg_date2'].strftime('%d.%m.%Y'), entry['id__count'],))
    
    return response

def books_total_count(request):
    # Возвращает количество книг на день за указанный период в формате CSV
    # get-параметр from - с какой даты показывать статистику, если не указана то с 12.11.2009 (дата импорта первых данных)
    # get-параметр to - по какую дату показывать статистику. Если не указано - то по текущий момент.
    # get-параметр owns: значения ya, pr или не указано. Фильтр по книгам компании, личным книгам, всем книгам.
    
    dt_from = datetime.strptime( request.GET.get('from','2009-11-12'), '%Y-%m-%d' ).date()
    dt_to = request.GET.get('to', datetime.now())
    
    ownership = request.GET.get('owns', None)
    
    books_stat = BookItem.objects.filter(reg_date__lte=dt_to)
    
    if ownership:
        books_stat = books_stat.filter(ownership_choices = ownership.upper())
    
    books_stat = books_stat.extra(select={'reg_date2':"DATE(`reg_date`)"}).values('reg_date2').annotate(Count('id')).order_by('reg_date2')
    
    response = HttpResponse(mimetype = 'text/csv')
    response['Content-Disposition'] = 'attachment; filename = lib-statistics.csv'
    
    writer = csv.writer(response)
    total = 0
    for entry in books_stat:
        total += entry['id__count']
        if entry['reg_date2'] >= dt_from:
            writer.writerow((entry['reg_date2'].strftime('%d.%m.%Y'), total,))
    
    return response