# coding: utf-8
'''
    Модуль для работы с разными поставщиками информации о книгах (амазон, др.)
    Предоставляет функционал для поиска книги и получения информации (описание, обложки, ссылки на магазины..)
    о ней.
'''

import urllib2

from urllib import quote_plus
from libra.pyaws import ecs
from xml.parsers.expat import ExpatError

from libra.books.vendors import get_vendor


class BookInfo():
    title   = ''
    author  = ''
    isbn10  = ''
    isbn13  = ''
    description = ''
    url_details = ''
    provider    = ''
    small_image = ''
    medium_image = ''
    large_image = ''

class NoRedirect(urllib2.HTTPRedirectHandler):
    def redirect_request(self, req, fp, code, msg, hdrs, newurl):
        pass

class BookProvider():
    ecs.setLicenseKey('AKIAIURAOOTKLKTVKI4A')
    ecs.setSecretKey('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')
    rus = u'абвгдеёжзийклмнопрстуфхцчшщыэюяъь'
    
    def search_book(self, title, author=None, isbn=None, max_results=10):
        if len(title) <= 5:
            return []
        if not self.is_rus(title) and not self.is_rus(author):
            return self.search_amazon(title, author=author, isbn=isbn, max_results=10)
        else:
            return self.search_ozon(title, author, max_results=10)
    
    def search_amazon(self, text, author=None, isbn=None, max_results=100):
        '''
            Ищет книгу с заданным заголовком на Амазоне.
        '''
        items = []
        if isbn:
            pass
        else:
            exclude_books = [u'English-Russian', u'The search.', u'JavaScript', u'Microsoft Windows Server 2003']
            try:
                if text in exclude_books : return [] # костыль, убирающий тупняки Амазона
                query = dict(SearchIndex="Books", Title=text, ResponseGroup="Images,Small", AssociateTag="yndx-1")
                if author:
                    query["Author"] = author
                items = ecs.ItemSearch(**query)
            except (KeyError, ExpatError):
                items = []
            except UnicodeEncodeError:
                print '!! UnicodeEncodeError: '
                items = []
        books = []
        for item in items:
            if hasattr(item, 'LargeImage'):
                large_image_url = item.LargeImage.URL
                #TODO: Заворачивать все в класс BookInfo
                books.append( {'title':item.Title, 'authors':getattr(item, 'Author', '')[:254],
                               'image_l':large_image_url,'image_m':item.MediumImage.URL, 'image_s':item.SmallImage.URL} )
            if len(books) == max_results:
                break
        return books

    def search_ozon(self, title, author, max_results=100):
        if type(title) == unicode:
            try:
                title = title.encode('WINDOWS-1251')
            except UnicodeEncodeError:
                return []
        if type(author) == unicode:
            try:
                title += ' ' + author.encode('WINDOWS-1251')
            except UnicodeEncodeError:
                return []
        url = 'http://www.ozon.ru/?context=search&text=' + quote_plus(title)

        book_url = None
        search_result = None
        try:
            search_result = self.__get_opener().open(url)
        except urllib2.HTTPError as e:
            if e.code == 302:
                book_url = e.headers['location']
                if book_url.find('/detail/id/') == -1:
                    try:
                        search_result = self.__get_opener().open(book_url)
                        book_url = None
                    except:
                        return []
            else:
                return []
        if book_url:
            v = get_vendor(book_url)
            if v and v.resolve():
                if not v.title or not v.authors or not v.cover:
                    return []
                data = dict(title=v.title, isbn=v.isbn, image_l=v.cover, authors=v.authors)
                data['image_m'] = v.cover.replace('/books_covers/', '/books_covers/c200/')
                data['image_s'] = v.cover.replace('/books_covers/', '/books_covers/c200/')
                return [data]
        elif search_result:
            try:
                search_result = search_result.read().decode('WINDOWS-1251')
            except:
                return []
            st = search_result.find('class="SearchResults"')
            boundary = search_result.find('id="PageLeft"')
            if st > -1:
                result = []
                st = search_result.find('class="jsUpdateLink jsPic"', st)
                while st > -1 and st < boundary:
                    if len(result) == max_results:
                        return result
                    st = search_result.find('src="', st)
                    if st > -1:
                        st += 5
                        end = search_result.find('"', st)
                        data = dict(title=title, authors=author, image_s='http:' + search_result[st:end])
                        if data['image_s'].find('noimg') == -1:
                            data['image_m'] = data['image_s']
                            data['image_l'] = data['image_s'].replace('/c200/', '/')
                            result.append(data)
                    st = search_result.find('class="jsUpdateLink jsPic"', st)
                return result
        return []

    def is_rus(self, text):
        ltext = text.strip().lower()
        letter_count = len(ltext)
        
        for l in self.rus:
            ltext = ltext.replace(l, '')
        
        rus_count = letter_count - len(ltext.strip(self.rus))
        if rus_count > 0:
            return True
        else:
            return False

    def __get_opener(self):
        if not hasattr(self, 'opener'):
            self.opener = urllib2.build_opener(NoRedirect)
        return self.opener


