# coding: utf-8
from django.conf import settings
from django.template.loader import render_to_string
from django.core.mail import EmailMessage


class MailRenderer():
    @staticmethod
    def render_purchase_request(purchase_request):
        u' рендерит Заявку на покупку в текстовое сообщение '

        requested_books = purchase_request.requested_books.all()

        body = render_to_string(
            'orders/mail.html',
            {
                'requested_books': requested_books,
                'req': purchase_request,
                'SERVER_HOST': settings.SERVER_HOST
            }
        )

        recepients = settings.DEFAULT_ORDER_EXECUTER[:]

        if purchase_request.approve_man:
            recepients += [purchase_request.approve_man.work_email]

        from_field = u'"%s %s" <%s>' % (
            purchase_request.customer.first_name,
            purchase_request.customer.last_name,
            purchase_request.customer.work_email,
        )
        subject = u'Заявка на покупку книг # %d от %s' % (
            purchase_request.id,
            purchase_request.created_at.strftime('%d.%m.%Y'),
        )

        return {
            'to': recepients,
            'body': body,
            'from': from_field,
            'subject': subject
        }


class MailManager():
    u'Управление рассылкой уведомлений'

    def __init__(self):
        self.queue = []  # имитация очереди отправки сообщений

    def add_object(self, object):
        '''
        Добавляет произвольный объект в очередь
        (объект должен имплементировать метод render_msg_pack() )
        '''
        msg_pack = object.render_msg_pack()
        self.add_message(msg_pack)

    def add_message(self, msg_pack):
        u' Добавляет словарь в заданном формате в очередь отправки сообщений '
        self.queue.append(msg_pack)  # Добавим сообщение в очередь
        # Пока нет другого механизма (агрегации) - рассылаем письма сразу
        self.process_queue()

    def view_message(self, msg_id):
        u' Просмотр сообщения в очереди '
        pass

    def process_queue(self):
        u' Обработывает (рассылает) очередь сообщений '
        for msg_pack in self.queue:
            msg = EmailMessage(
                msg_pack['subject'],
                msg_pack['body'],
                msg_pack['from'],
                msg_pack['to']
            )
            msg.content_subtype = "html"
            msg.send()
            self.queue.remove(msg_pack)
