# coding: utf-8

from django.contrib import admin
from libra.books.models import (
    Book,
    BookItem,
    BookCover,
    ReportEmail,
    Publisher,
    Opinion,
    ReadHistory,
    VariantBookInfo,
    TagCategory,
    PurchaseRequest,
)
from django_intranet_stuff.models import Staff


class BookCoverAdmin(admin.ModelAdmin):
    fields = ['img_large', 'image_tag']
    readonly_fields = ('image_tag',)
    list_display = ['image_tag', 'id']


class BookAdmin(admin.ModelAdmin):
    fields = (
        ('image_tag', 'main_cover'),
        ('title', 'authors_string'),
        'publisher',
        'years',
        'reg_date',
        ('shelf', 'case'),
        ('mulca_file', 'remove_the_file'),
        'at_id',
    )

    readonly_fields = ('image_tag',)
    search_fields = ('title', )
    list_select_related = True
    raw_id_fields = ['main_cover', 'publisher']


class BookItemAdmin(admin.ModelAdmin):
    fieldsets = (
        (None, {
                'fields': (
                    ('image_tag', 'cover'),
                ),
            }
        ),
        (None, {
                'fields': (
                    ('book', ),
                    ('year', 'is_active'),
                    ('rfid', 'isbn'),
                    ('ownership_choices', 'owner'),
                ),
            }
        ),
        (u'Размещение', {
            'fields': (
                ('case', 'shelf', 'is_tablebook'),
                ('office', 'location_staff', 'location_text'),
            ),
        }),
        (u'прочее', {
            'classes': ('collapse',),
            'fields': (
                ('registrator_staff',),
                ('cost', 'is_paper'),
                ('src_choices',),
            ),
        }),
    )
    readonly_fields = ('location_text', 'image_tag')
    search_fields = ('book__title', )
    raw_id_fields = ('location_staff', 'book', 'owner', 'registrator_staff', 'cover')

    list_select_related = True


    def save_model(self, request, obj, form, change):
        super(self.__class__, self).save_model(request, obj, form, change)
        if 'location_staff' in form.changed_data:
            obj.move_to_user(obj.current_reader)



class PublisherAdmin(admin.ModelAdmin):
    pass


class OpinionAdmin(admin.ModelAdmin):
    pass


class ReadHistoryAdmin(admin.ModelAdmin):
    list_select_related = True
    readonly_fields = ('reader', 'book', 'book_item')
    list_display = ('__unicode__', 'reader', 'book', 'book_item', 'get_date', 'return_date')
    search_fields = ('reader__login', 'reader__first_name', 'reader__last_name', 'book__title')


class VariantBookInfoAdmin(admin.ModelAdmin):
    list_filter = ('current',)


class TagCategoryAdmin(admin.ModelAdmin):
    pass


class PurchaseRequestAdmin(admin.ModelAdmin):
    list_select_related = True
    raw_id_fields = ['approve_man']


class StaffAdmin(admin.ModelAdmin):
    search_fields = ('login', 'first_name', 'last_name')


admin.site.register(BookCover, BookCoverAdmin)
admin.site.register(Book, BookAdmin)
admin.site.register(BookItem, BookItemAdmin)
admin.site.register(Publisher, PublisherAdmin)
admin.site.register(Opinion, OpinionAdmin)
admin.site.register(ReadHistory, ReadHistoryAdmin)
admin.site.register(VariantBookInfo, VariantBookInfoAdmin)
admin.site.register(TagCategory, TagCategoryAdmin)
admin.site.register(PurchaseRequest, PurchaseRequestAdmin)
admin.site.register(ReportEmail)
admin.site.register(Staff, StaffAdmin)
