# coding: utf8

from django import forms
from libra.books.models import BookItem, RfidFormField
from libra.utils import replace_form_error_messages
from django_intranet_stuff.models import Office


class UploadBookForm(forms.Form):
    u'Форма закачки файлов книги'
    bookitem_id = forms.IntegerField(
        label=u'ID вирт. экземпляра',
        widget=forms.HiddenInput,
        required=False
    )
    label = forms.CharField(label=u'Название файла', required=False)
    file = forms.FileField(label=u'Загрузить файл книги')


class AddBookForm(forms.Form):
    u' Форма добавления экземпляра книги '
    title = forms.CharField(max_length=255, label=u'Название книги')
    authors_string = forms.CharField(
        max_length=255,
        label=u'Авторы',
        help_text=u'(через запятую)',
        required=False
    )
    isbn = forms.CharField(max_length=30, required=False, label='ISBN')
    is_paper = forms.BooleanField(
        initial=True,
        label=u'Это бумажное издание',
        required=False
    )
    publisher_name = forms.CharField(
        max_length=250,
        label=u'Издательство',
        required=False
    )
    # ИД издательства, которое могли выбрать из автокомплита
    publisher_id = forms.IntegerField(
        widget=forms.HiddenInput,
        required=False
    )
    ownership_choices = forms.ChoiceField(
        choices=BookItem.OWNERSHIP_CHOICES,
        initial='YA',
        label=u'Книга принадлежит'
    )
    owner = forms.CharField(
        max_length=250,
        required=False,
        label=u'Владелец',
        help_text=u'введите логин или ФИО'
    )
    # Скрытое поле, куда попадает логин владельца
    owner__login_ld = forms.CharField(
        max_length=250,
        widget=forms.HiddenInput,
        required=False
    )

    LOCATION_CHOICES = (('lib', u'в библиотеке'), ('onhands', u'на руках'))
    location_choices = forms.ChoiceField(
        initial='lib',
        choices=LOCATION_CHOICES,
        label=u'Где находится',
        widget=forms.widgets.RadioSelect(attrs={'class': 'location_widget'})
    )
    # У кого из сотрудников сейчас экземпляр книги?
    location_staff = forms.CharField(
        max_length=250,
        label=u'у кого',
        required=False,
        help_text=u'введите логин или ФИО'
    )
    # Скрытое поле, куда попадает логин сотрудника, у которого книга на руках
    location_staff__login_ld = forms.CharField(
        max_length=250,
        widget=forms.HiddenInput,
        required=False
    )
    is_tablebook = forms.BooleanField(
        initial=False,
        label=u'настольная книга',
        required=False
    )

    office = forms.ModelChoiceField(
        queryset=Office.objects.all(),
        required=False,
        initial=Office.objects.filter(
            name__icontains=u'Морозов',
        )[0],
        label=u'Офис',
    )
    cost = forms.DecimalField(
        max_digits=7,
        decimal_places=2,
        required=False,
        label=u'Стоимость, руб',
        widget=forms.TextInput(attrs={'class': 'cost_field', 'size': 10})
    )
    year = forms.DecimalField(
        max_digits=4,
        decimal_places=0,
        required=False,
        label=u'год издания'
    )
    comment = forms.CharField(
        max_length=255,
        label=u'Примечание',
        required=False,
        widget=forms.Textarea(attrs={'rows': 4, 'class': 'comment_field', 'cols': 35})
    )
    rfid = RfidFormField(
        label=u'RFID метка',
        required=False,
        max_length=15,
        widget=forms.TextInput(attrs={'class': 'rfid_field', 'size': 18, 'autocomplete': 'off'})
    )

    case = forms.IntegerField(label=u'Шкаф', required=False)
    shelf = forms.IntegerField(label=u'Полка', required=False)

replace_form_error_messages(AddBookForm, {
    'title': {'required': u'введите название книги'},
    'location_choices': {'required': u'укажите где находится книга'},
    'isbn': {
        'invalid': u'Введите числовой номер (можно с разделителями)',
        'max_digits': u'Введите не более %s цифр'
    }
})


class FilterCityBookForm(forms.Form):
    office = forms.ModelChoiceField(
        queryset=Office.objects.filter(bookitem__isnull=False).distinct(),
        required=False, label='Офис')
