#coding: utf-8
from django.conf import settings
from django import forms

from django_intranet_stuff.models import Office, Staff
from libra.books.models import PurchaseRequest, PurchaseRequestOneBook
from libra.utils import replace_form_error_messages
from django.forms.util import ErrorDict

# Модуль форм подсистемы заказа покупки книжек
class RequestForm(forms.ModelForm):
    u' Форма сопровождения заявки на покупку книги '
    approve_man = forms.CharField(max_length=250, required=False, label=u'Уведомить руководителя',
                                  help_text=u'Если руководитель не определился автоматически, укажите его', widget=forms.TextInput(attrs={'class':'approve-man-field'}))
    approve_man__login_ld = forms.CharField(widget=forms.HiddenInput(), required=False)

    class Meta:
        model = PurchaseRequest
        fields = ('approve_man__login_ld','approve_man', 'delivery_office',) # первым полем должно идти 'approve_man__login_ld' чтобы пройти валидацию первым.

    def clean_approve_man__login_ld(self):
        boss_login = self.cleaned_data.get('approve_man__login_ld', None)
        return boss_login

    def clean_approve_man(self):
        if self.cleaned_data['approve_man']:
            # Если что-то введено в поле руководитель, то нужно чтобы его выбрали из списка, тогда логин придет сюда в скрытом поле
            boss_login = self.cleaned_data.get('approve_man__login_ld', None)
            if boss_login:
                try:
                    boss = Staff.objects.get(login_ld=boss_login)
                    return boss
                except Staff.DoesNotExist:
                    raise forms.ValidationError(u'Не найден сотрудник с логином "%s"' % boss_login)
                except Staff.MultipleObjectsReturned:
                    raise forms.ValidationError(u'Задан не уникальный логин "%s"' % boss_login)

            else:
                raise forms.ValidationError(u'руководителя нужно выбрать из предложенного списка')

        else:
            return None


class MyURLField(forms.URLField):
    def clean(self, value):
        if value: value = value.strip()
        return super(forms.URLField, self).clean(value)


class RequestOneBookForm(forms.ModelForm):
    u' Форма заявки на 1 книгу. Форма множится на заданное количество книг '
    count = forms.IntegerField(label=u'Количество', widget=forms.TextInput(attrs={'class':'count-field'}))
    cost1 = forms.DecimalField(max_digits=10, decimal_places=2, label=u'Цена 1 экземпляра, руб.', widget=forms.TextInput(attrs={'class':'cost-field'}))

    # пришлось кастомизировать поле, чтобы перед стандартной валидацией URL убрать пробельные символы по краям
    url =   MyURLField(verify_exists=False, label=u'Адрес страницы покупки книги', required=True)

    class Meta:
        model = PurchaseRequestOneBook
        fields = ('title', 'url', 'count', 'cost1','comment')

        #FIXME: Не применяется до Django 1.2 
        widgets = {
            'count': forms.TextInput(attrs={'class':'count-field'}),
            'cost1': forms.TextInput(attrs={'class':'cost-field'}),
            'comment': forms.Textarea(attrs={'class':'request-comment-field'})
        }


replace_form_error_messages(RequestForm, {
    'approve_man': {'required': u'введите название книги'},
    'delivery_office': {'required': u'укажите где находится книга'},
})

replace_form_error_messages(RequestOneBookForm, {
    'title': {'required': u'введите название книги'},
    'url': {'required': u'Адрес заказа книги обязателен', 'invalid':u'Введите корректный адрес страницы. Например, http://www.ozon.ru/context/detail/id/4846631/'},
    'count': {'required': u'Сколько книг покупать?'},
    'comment': {'required': u'Напишите обоснование, пожалуйста'},
    'cost1': {'required': u'Укажите стоимость книги (можно приблизительную) в рублях'},
})