# coding: utf8

from django import forms 
from libra.books.models import Publisher
from libra.utils import replace_form_error_messages

class AddPublisherForm(forms.ModelForm):
    class Meta:
        model = Publisher

class DeletePublisherForm(forms.Form):
    ACTION_CHOICES = (('keep_empty',u'Оставить эти книги без указания издательства'),('replace',u'Поменять издательство на предложенное из списка:'))
    action_choices      = forms.ChoiceField(initial='keep_empty',choices=ACTION_CHOICES,widget=forms.widgets.RadioSelect(),required=False)
    replace_publisher   = forms.ModelChoiceField(queryset=Publisher.objects.all(),required=False, widget=forms.widgets.RadioSelect())