# coding: utf-8
from django.conf import settings
from django.core.management.base import BaseCommand
from django.core.exceptions import ObjectDoesNotExist, MultipleObjectsReturned
from libra.books.models import Book, VariantBookInfo
from optparse import make_option
from libra.book_info_provider import BookProvider

import cPickle

class Command(BaseCommand):
    help = u"Export & import cover's info"

    option_list = BaseCommand.option_list + (
        make_option('--export', action='store_true', dest='is_export',
            help='export cover-book links to file'),
        make_option('--import', action='store_true', dest='is_import',
            help='import cover-book links from file'),
        make_option('--file', action='store', dest='file',
            help='filename'),
    )
    
    def handle(self, *args, **options):
        is_export = options.get('is_export', False)
        is_import = options.get('is_import', False)
        filename = options.get('file', u'/var/tmp/covers.txt')
        
        f = open(filename, 'w')
        if is_export:
            vbs = VariantBookInfo.objects.filter(current=1).select_related('book')
            data = []
            for vb in vbs:
                rec = {
                       'lib_book_title':vb.book.title, 'lib_book_authors':vb.book.authors_string,
                       'vb_book_title':vb.title, 'vb_authors':vb.authors,
                       'vb_image_l': vb.image_l_url
                       }
                data.append(rec)
            
            cPickle.dump(data, f)
            print u'Exported %d book-links to covers' % (len(data),)
        
        elif is_import:
            pass