# coding: utf-8
from django.core.management.base import BaseCommand
from django.core.files.base import ContentFile
from django.db.transaction import commit_on_success

from django_elliptics.storage.errors import ReadError as EllipticsReadError
from mds import APIError as MDSWriteError
from libra.books.models import BookCover
from libra.books.storage import is_elliptics_name


@commit_on_success
def migrate_release_file(file_id):
    release_file = BookCover.objects.select_for_update().get(id=file_id)
    file_path = release_file.img_large
    file_name = str(file_path).split('/')[-1]

    try:
        content = release_file.img_large.read()
        content_file = ContentFile(content=content, name=file_name)
        release_file.img_large.save(name=file_name, content=content_file)
    except EllipticsReadError as exc:
        print 'ELLIPTICS READ ERROR: %s' % exc
    except MDSWriteError as exc:
        print 'MDS WRITE ERROR: %s' % exc.message
    else:
        return True

    return False


class Command(BaseCommand):
    help = 'Upload release files from Elliptics to MDS'

    def handle(self, *args, **options):
        release_files = (
            BookCover.objects.exclude(img_large='')
            .values_list('id', 'img_large')
        )
        release_files_count = len(release_files)
        release_file_ids_to_upload = [
            _id for _id, dist in release_files if is_elliptics_name(dist)]
        elliptics_files_count = len(release_file_ids_to_upload)

        uploaded_files_count = 0
        for i, release_file_id in enumerate(release_file_ids_to_upload):
            if i and not i % 100:
                print '%d files was processed' % i

            is_ok = migrate_release_file(release_file_id)
            if is_ok:
                uploaded_files_count += 1

        fails_count = elliptics_files_count - uploaded_files_count
        print 'Count of release files: %d' % release_files_count
        print 'Count of Elliptics files: %d' % elliptics_files_count
        print 'Count of uploaded to MDS files: %d' % uploaded_files_count
        print 'Count of fails: %d' % fails_count
