# coding: utf-8
""" Перевозим обложки с файловой системы в эллиптикс

Выгрузка данных в файл
"""

import os
from django.core.management.base import BaseCommand
from libra.books.models import BookCover


class Command(BaseCommand):
    help = u"Export cover's info to file"

    def handle(self, *args, **options):
        with open('covers.txt', 'w') as out:
            for cover in BookCover.objects.all():
                filename = os.path.basename(cover.img_large.path)
                cover.img_large.close()
                out.write('%s\t%s\n' % (cover.id, filename))
