# coding: utf-8
import re

from django.conf import settings
from django.core.management.base import BaseCommand
from ids.registry import registry

from libra.utils import lock
from libra.books.utils import create_atpost
from libra.books.models import Book


class Command(BaseCommand):
    help = u"Склеивает треды в этушке с книжкой"

    @lock('import_all_books_to_at')
    def handle(self, *args, **kwargs):
        def print_info(msg):
            if int(kwargs.get('verbosity', 1)):
                print msg

        rep = registry.get_repository('at', 'post')

        ids = set()
        pattern = re.compile(r'lib.yandex-team.ru/books/(\d+)')
        for post in rep.getiter({'uid': settings.AT_CLUB_ID}):
            url = (post.get('meta') or {}).get('url', '')

            book_id = re.findall(pattern, url)
            if not book_id:
                print_info("Can't find book_id in \"%s\"" % url)
                continue
            else:
                book_id = book_id[0]

            ids.add(int(book_id))

        for book in Book.objects.all().exclude(id__in=ids):
            try:
                b_item = book.bookitem_set.all()[0]
            except IndexError:
                print_info("Book %s doesn't have any book_item" % book.id)
            else:
                # создаем их в прошлом
                create_atpost(b_item, store_time='1300000000')
