# coding: utf-8
from django.conf import settings
from django.core.management.base import BaseCommand
from django.core.exceptions import ObjectDoesNotExist, MultipleObjectsReturned
from django.utils.encoding import smart_str
from libra.books.models import Book, VariantBookInfo
from _mysql_exceptions import Warning

from libra.utils import lock
from libra.book_info_provider import BookProvider


class Command(BaseCommand):
    help = u"Search book's info and cover' images on popular sites, like Amazon, etc.."
    @lock('importcovers')
    def handle(self, *args, **options):
        bp = BookProvider()
        books = Book.objects.all().order_by('-reg_date')
        total_count = len(books)
        found = 0
        for b in books:
            VariantBookInfo.objects.all().filter(book=b, current=False).delete()   # Удалим старые варианты доп. инфо

            try:
                # Если уже есть привязанная информация о книге - пропускаем книгу
                vb = VariantBookInfo.objects.get(book=b, current=True)
            except ObjectDoesNotExist:
                # Если нет сопоставленной допинфо - ищем её в инете
                print smart_str('Searching for ' + b.title)
                variants = bp.search_book(title=b.title, author=b.authors_string)
                print smart_str('Found %d covers' % len(variants))
                if len(variants) > 0:
                    found += 1
                    for v in variants[:10]:
                        variant = VariantBookInfo()
                        variant.book = b
                        variant.title = v['title']

                        if isinstance(v['authors'], list):
                            variant.authors = ', '.join(v['authors'])
                        else:
                            variant.authors = v['authors']

                        variant.image_l_url = v['image_l']
                        variant.image_s_url = v['image_s']
                        variant.image_m_url = v['image_m']

                        if len(variants) == 1:
                            variant.current = True
                        try:
                            variant.save()
                        except Warning:
                            pass
            except MultipleObjectsReturned:
                print 'book:', b, ' -- is selected more then once as current!'

        print 'books cnt:', total_count, 'has covers:', found
