# -*- coding: utf-8 -*-

import datetime

from django.conf import settings
from django.core.mail import EmailMessage
from django.core.management.base import BaseCommand
from django.template.loader import render_to_string

from libra.utils import lock
from libra.books.models import ReadHistory, ReportEmail


class Command(BaseCommand):
    help = u'Отчёт менеджеру о задержанных сверх меры книгах'

    @lock('longtimebusy')
    def handle(self, *args, **options):
        r_mails = ReportEmail.objects.values_list('email', flat=True)
        history = ReadHistory.taken_long_ago()
        body = render_to_string('longtimebusy-mail.html',
                                {'history_users_books': history})
        format_day = datetime.date.today().strftime('%d.%m.%Y')
        email_from = settings.SERVER_EMAIL
        if email_from and r_mails:
            subj = u'Отчет о просроченных книгах на %s' % (format_day)
            msg = EmailMessage(subj, body, email_from, r_mails)
            msg.content_subtype = "html"
            if settings.LONG_TIME_BUSY_MAIL:
                msg.send()
