# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand
from django.db.models import Q

from libra.books.models import BookItem
from django_intranet_stuff.models import Office
from libra.utils import UnicodeWriter

DEFAULT_FILENAME = '/var/log/yandex/tools-libra/lost_history.csv'


class Command(BaseCommand):
    help = u'Export lost books from RedRose, Morozov'

    def handle(self, *args, **options):
        logfile = args[0] if len(args) == 1 else DEFAULT_FILENAME
        office_id = Office.objects.filter(name__contains='Морозов')[0].id

        table = sorted((
            (
                unicode(h.id),
                unicode(bi.book.title),
                unicode(h.reader),
                unicode(h.get_date),
                unicode(h.return_date)
            )
            for bi in strange_books(office_id)
            for h in bi.readhistory_set.all()
        ), key=lambda x: x[3])

        with open(logfile, 'wb') as f:
            writer = UnicodeWriter(f)
            writer.writerow((
                u'history_id',
                u'book_title',
                u'reader',
                u'get_date',
                u'return_date'
            ))
            writer.writerows(table)

def strange_books(office_id):
    for b in BookItem.objects.filter(
            Q(office__id=office_id) &
            (Q(shelf__isnull=True) | Q(case__isnull=True))
        ):
        if b.readhistory_set.exists():
            last = b.readhistory_set.latest('id')
            if (b.location_staff_id != last.reader_id
                and last.return_date == None):
                    yield b
