# coding: utf-8

from datetime import datetime
from itertools import groupby
from django.core.management.base import BaseCommand
from django.core.mail import EmailMessage
from django.template.loader import render_to_string
from django.conf import settings

from libra.books.models import BookQueue
from libra.utils import lock


class Command(BaseCommand):
    help = u""" Посылает письмо о том кто и на какие книги подписался """

    @lock('queue_summary')
    def handle(self, *args, **options):
        bqs = BookQueue.objects.select_related('user', 'book').filter(
            finished=False).order_by('book', 'user__office', 'created_at')

        res = []
        for book, bqs_by_books in groupby(bqs, key=lambda x: x.book):
            data = {'book': book, 'logins': [], 'count': 0}
            for bq in bqs_by_books:
                data['logins'].append(bq.user.login)
                data['count'] += 1
            data['logins'] = ', '.join(data['logins'])
            res.append(data)

        send_letter(res)


def send_letter(data):
    body = render_to_string('book_queue_summary.html', {'data': data})
    subj = u'Отчет. Книги на которые подписаны люди. %s' % datetime.now()
    email_from = settings.RETURN_BOOK_FROM

    msg = EmailMessage(subj, body, email_from,
                       [eml[1] for eml in settings.MANAGERS])
    msg.content_subtype = "html"

    if settings.RETURN_BOOK_MAIL:
        msg.send()
