# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand

from libra.books.models import BookItem
from libra.utils import UnicodeWriter

DEFAULT_FILENAME = '/var/log/yandex/tools-libra/shelves.csv'


class Command(BaseCommand):
    help = u'Export books by case & shelf from RedRose, Morozov'

    def handle(self, *args, **options):
        logfile = args[0] if len(args) == 1 else DEFAULT_FILENAME
        table = (
            (unicode(b.case), unicode(b.shelf), unicode(b.book.title), unicode(b.rfid))
            for b in BookItem.objects.filter(office__id=2L, case__isnull=False, shelf__isnull=False)
        )
        with open(logfile, 'wb') as f:
            writer = UnicodeWriter(f)
            writer.writerows(table)
