# -*- coding: utf-8 -*-

import datetime

from django.conf import settings
from django.core.mail import EmailMessage
from django.core.management.base import BaseCommand
from django.template.loader import render_to_string

from libra.books.models import ReportEmail
from libra.utils import lock
from libra.books.stats import *


class Command(BaseCommand):
    help = u'Рассылка со статистикой'

    @lock('statistics')
    def handle(self, *args, **options):
        r_mails = ReportEmail.objects.values_list('email', flat=True)
        format_day = datetime.date.today().strftime('%d.%m.%Y')
        body = render_to_string(
            'stats/lost-books.html',
            {
                'data': LostBooks().data(),
            }
        )
        email_from = settings.SERVER_EMAIL
        copy = [settings.RETURN_BOOK_FROM]
        if email_from and r_mails:
            subj = u'Отчет об утерянных книгах на %s' % (format_day)
            msg = EmailMessage(subj, body, email_from, r_mails, cc=copy)
            msg.content_subtype = "html"
            msg.send()
        body = render_to_string(
            'stats/orders.html',
            {
                'data': Orders().data(),
            }
        )
        if email_from and r_mails:
            subj = u'Отчет о заказах книг на %s' % (format_day)
            msg = EmailMessage(subj, body, email_from, r_mails, cc=copy)
            msg.content_subtype = "html"
            msg.send()
        body = render_to_string(
            'stats/returns.html',
            {
                'data': Returns().data(),
            }
        )
        if email_from and r_mails:
            subj = u'Отчет о возвратах книг на %s' % (format_day)
            msg = EmailMessage(subj, body, email_from, r_mails, cc=copy)
            msg.content_subtype = "html"
            msg.send()
        
