# -*- coding:utf-8 -*-
from django.conf import settings
from django_xscript.middleware import XScriptMiddleware
from django.utils import simplejson as json

class LazyUser(object):
    '''
        Код взят из PLANNER.Middleware
    '''
    def __init__(self, login_ld=None):
        self.login_ld = login_ld

    def __get__(self, request, obj_type=None):
        if not hasattr(request, '_cached_user'):
            if self.login_ld:
                from django.contrib.auth.models import User
                try:
                    request._cached_user = User.objects.get(username=self.login_ld)
                except User.DoesNotExist:
                    request._cached_user = User.objects.create_user(self.login_ld, '%s@yandex-team.ru' % self.login_ld)
            else:
                from django.contrib.auth.models import AnonymousUser
                request._cached_user = AnonymousUser()
            request._cached_user.__class__.profile = LazyProfile()
        return request._cached_user


class LazyProfile(object):
    def __get__(self, user, obj_type=None):
        if user:
            from django_intranet_stuff.models import Staff
            try:
                return Staff.objects.get(login_ld=user.username)
            except Staff.DoesNotExist:
                return None
        return None

class DummyUserAuthMiddleware(object):
    '''
        Авторизационная заглушка - авторизует пользователя под логином settings.DUMMY_PASSPORT_USER
    '''
    def process_request(self,request):
        if hasattr(settings,'DUMMY_PASSPORT_USER') and settings.DUMMY_PASSPORT_USER:
            request.__class__.user = LazyUser(settings.DUMMY_PASSPORT_USER)
        # print request.user.profile.login_ld
        return None

#class XScriptWithJsonMiddleware(XScriptMiddleware):
#     def process_response(self, request, response, initialized=[]):
#         if not response['content-type'].startswith('application/javascript'):
#             print "not javascript content-type!?"
#             return XScriptMiddleware.process_response(self, request, response, initialized)
# 
#         try:
#             # парсим
#             content = json.loads(response.content)
# 
#         # если это обычный js, а не json ответ
#         # но вообще по-хорошему джанга не должна js'ы отдавать
#         except ValueError:
#             return XScriptMiddleware.process_response(self, request, response, initialized)
# 
#         if not isinstance(content, dict):
#             return XScriptMiddleware.process_response(self, request, response, initialized)
# 
#         html = content.get('html', None)
#         if not html:
#             return XScriptMiddleware.process_response(self, request, response, initialized)
# 
#         # отправляем лего преобразовываться в хтмл
#         # предварительно обернув собственным тегом
#         response.content = '<mytag>' + html + '</mytag>'
#         response['content-type'] = 'text/html'
#         new_res = XScriptMiddleware.process_response(self, request, response, initialized)
#
#         # само содержимое нового ответа меняем опять на json,
#         # но с заменой лего на html
#         new = new_res.content
#         # берем содержимое <mytag>...</mytag>
#         # и записываем в словарь вместо старого лего
#         content['html'] = new[new.find('<mytag>')+len('<mytag>'):new.find('</mytag')]
# 
#         new_res.content = json.dumps(content)
#         new_res['content-type'] = 'application/javascript'
#         return XScriptMiddleware.process_response(self, request, new_res, initialized)


