# coding: utf-8

from south.db import db
from django.db import models
from libra.books.models import *

class Migration:
    
    def forwards(self, orm):
        
        # Adding model 'PurchaseOrder'
        db.create_table('books_purchaseorder', (
            ('id', models.AutoField(primary_key=True)),
            ('number', models.CharField(default='', max_length=30, blank=True)),
            ('shop', models.ForeignKey(orm.Shop)),
            ('executor', models.ForeignKey(orm.RequestExecutor)),
            ('created_at', models.DateTimeField(auto_now_add=True)),
        ))
        db.send_create_signal('books', ['PurchaseOrder'])
        
        # Adding model 'RequestExecutor'
        db.create_table('books_requestexecutor', (
            ('id', models.AutoField(primary_key=True)),
            ('staff', models.ForeignKey(orm['users.Staff'])),
            ('office', models.ForeignKey(orm['users.Office'], null=True, blank=True)),
        ))
        db.send_create_signal('books', ['RequestExecutor'])
        
        # Adding model 'Shop'
        db.create_table('books_shop', (
            ('id', models.AutoField(primary_key=True)),
            ('url_part', models.CharField(unique=True, max_length=50)),
            ('name', models.CharField(unique=True, max_length=50)),
        ))
        db.send_create_signal('books', ['Shop'])
        
        # Adding model 'PurchaseRequest'
        db.create_table('books_purchaserequest', (
            ('id', models.AutoField(primary_key=True)),
            ('title', models.CharField(max_length=255)),
            ('url', models.URLField(verify_exists=False)),
            ('count', models.IntegerField(default=1)),
            ('state', models.CharField(default='NEW', max_length=10)),
            ('shop', models.ForeignKey(orm.Shop)),
            ('cost1', models.DecimalField(default=0, max_digits=10, decimal_places=2, blank=True)),
            ('delivery_office', models.ForeignKey(orm['users.Office'])),
            ('approve_man', models.ForeignKey(orm['users.Staff'], related_name='approve_requests', null=True, blank=True)),
            ('executor', models.ForeignKey(orm.RequestExecutor)),
            ('customer', models.ForeignKey(orm['users.Staff'], related_name='made_requests')),
        ))
        db.send_create_signal('books', ['PurchaseRequest'])
        
        # Adding model 'RequestFlow'
        db.create_table('books_requestflow', (
            ('id', models.AutoField(primary_key=True)),
            ('datetime', models.DateTimeField(auto_now_add=True)),
            ('request', models.ForeignKey(orm.PurchaseRequest)),
            ('state', models.CharField(max_length=10)),
            ('changer', models.ForeignKey(orm['users.Staff'])),
        ))
        db.send_create_signal('books', ['RequestFlow'])
        
        # Adding field 'Book.years'
        db.add_column('books_book', 'years', models.CharField(default='', max_length=255, blank=True))
        
        # Changing field 'BookItem.comment'
        db.alter_column('books_bookitem', 'comment', models.CharField(max_length=255, blank=True))
        
        # Changing field 'BookItem.location_string'
        db.alter_column('books_bookitem', 'location_string', models.CharField(default='', max_length=200, blank=True))
        
        # Changing field 'BookItem.office'
        db.alter_column('books_bookitem', 'office_id', models.ForeignKey(orm['users.Office'], null=True, blank=True))
        
        # Changing field 'BookItem.registrator_staff'
        db.alter_column('books_bookitem', 'registrator_staff_id', models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        
        # Changing field 'BookItem.ownership_choices'
        db.alter_column('books_bookitem', 'ownership_choices', models.CharField(max_length=2))
        
        # Changing field 'BookItem.is_active'
        db.alter_column('books_bookitem', 'is_active', models.BooleanField(default=True))
        
        # Changing field 'BookItem.src_choices'
        db.alter_column('books_bookitem', 'src_choices', models.IntegerField(default=3))
        
        # Changing field 'BookItem.reg_date'
        db.alter_column('books_bookitem', 'reg_date', models.DateTimeField(auto_now_add=True))
        
        # Changing field 'BookItem.cost'
        db.alter_column('books_bookitem', 'cost', models.DecimalField(null=True, max_digits=7, decimal_places=2, blank=True))
        
        # Changing field 'BookItem.year'
        db.alter_column('books_bookitem', 'year', models.IntegerField(null=True, blank=True))
        
        # Changing field 'BookItem.is_paper'
        db.alter_column('books_bookitem', 'is_paper', models.BooleanField())
        
        # Changing field 'BookItem.location_staff'
        db.alter_column('books_bookitem', 'location_staff_id', models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        
        # Changing field 'BookItem.book'
        db.alter_column('books_bookitem', 'book_id', models.ForeignKey(orm['books.Book']))
        
        # Changing field 'Book.publisher'
        db.alter_column('books_book', 'publisher_id', models.ForeignKey(orm['books.Publisher'], null=True, blank=True))
        
        # Changing field 'Book.authors_string'
        db.alter_column('books_book', 'authors_string', models.CharField(max_length=255, blank=True))
        
        # Changing field 'Book.title'
        db.alter_column('books_book', 'title', models.CharField(max_length=255))
        
        # Changing field 'Publisher.name'
        db.alter_column('books_publisher', 'name', models.CharField(unique=True, max_length=250))
        
        # Changing field 'ReadHistory.get_date'
        db.alter_column('books_readhistory', 'get_date', models.DateTimeField(null=True, blank=True))
        
        # Changing field 'ReadHistory.return_date'
        db.alter_column('books_readhistory', 'return_date', models.DateTimeField(null=True, blank=True))
        
        # Changing field 'VariantBookInfo.current'
        db.alter_column('books_variantbookinfo', 'current', models.BooleanField(default=False))
        
        # Changing field 'Opinion.text'
        db.alter_column('books_opinion', 'text', models.TextField(blank=True))
        
        # Changing field 'Opinion.reader'
        db.alter_column('books_opinion', 'reader_id', models.ForeignKey(orm['users.Staff']))
        
        # Changing field 'Opinion.date'
        db.alter_column('books_opinion', 'date', models.DateTimeField(auto_now_add=True))
        
    
    
    def backwards(self, orm):
        
        # Deleting model 'PurchaseOrder'
        db.delete_table('books_purchaseorder')
        
        # Deleting model 'RequestExecutor'
        db.delete_table('books_requestexecutor')
        
        # Deleting model 'Shop'
        db.delete_table('books_shop')
        
        # Deleting model 'PurchaseRequest'
        db.delete_table('books_purchaserequest')
        
        # Deleting model 'RequestFlow'
        db.delete_table('books_requestflow')
        
        # Deleting field 'Book.years'
        db.delete_column('books_book', 'years')
        
        # Changing field 'BookItem.comment'
        db.alter_column('books_bookitem', 'comment', models.CharField(max_length=255, blank=True))
        
        # Changing field 'BookItem.location_string'
        db.alter_column('books_bookitem', 'location_string', models.CharField(default='', max_length=200, blank=True))
        
        # Changing field 'BookItem.office'
        db.alter_column('books_bookitem', 'office_id', models.ForeignKey(orm['users.Office'], null=True, blank=True))
        
        # Changing field 'BookItem.registrator_staff'
        db.alter_column('books_bookitem', 'registrator_staff_id', models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        
        # Changing field 'BookItem.ownership_choices'
        db.alter_column('books_bookitem', 'ownership_choices', models.CharField(max_length=2))
        
        # Changing field 'BookItem.is_active'
        db.alter_column('books_bookitem', 'is_active', models.BooleanField(default=True))
        
        # Changing field 'BookItem.src_choices'
        db.alter_column('books_bookitem', 'src_choices', models.IntegerField(default=3))
        
        # Changing field 'BookItem.reg_date'
        db.alter_column('books_bookitem', 'reg_date', models.DateTimeField(auto_now_add=True))
        
        # Changing field 'BookItem.cost'
        db.alter_column('books_bookitem', 'cost', models.DecimalField(null=True, max_digits=7, decimal_places=2, blank=True))
        
        # Changing field 'BookItem.year'
        db.alter_column('books_bookitem', 'year', models.IntegerField(null=True, blank=True))
        
        # Changing field 'BookItem.is_paper'
        db.alter_column('books_bookitem', 'is_paper', models.BooleanField())
        
        # Changing field 'BookItem.location_staff'
        db.alter_column('books_bookitem', 'location_staff_id', models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        
        # Changing field 'BookItem.book'
        db.alter_column('books_bookitem', 'book_id', models.ForeignKey(orm.Book))
        
        # Changing field 'Book.publisher'
        db.alter_column('books_book', 'publisher_id', models.ForeignKey(orm.Publisher, null=True, blank=True))
        
        # Changing field 'Book.authors_string'
        db.alter_column('books_book', 'authors_string', models.CharField(max_length=255, blank=True))
        
        # Changing field 'Book.title'
        db.alter_column('books_book', 'title', models.CharField(max_length=255))
        
        # Changing field 'Publisher.name'
        db.alter_column('books_publisher', 'name', models.CharField(max_length=250, unique=True))
        
        # Changing field 'ReadHistory.get_date'
        db.alter_column('books_readhistory', 'get_date', models.DateTimeField(null=True, blank=True))
        
        # Changing field 'ReadHistory.return_date'
        db.alter_column('books_readhistory', 'return_date', models.DateTimeField(null=True, blank=True))
        
        # Changing field 'VariantBookInfo.current'
        db.alter_column('books_variantbookinfo', 'current', models.BooleanField(default=False))
        
        # Changing field 'Opinion.text'
        db.alter_column('books_opinion', 'text', models.TextField(blank=True))
        
        # Changing field 'Opinion.reader'
        db.alter_column('books_opinion', 'reader_id', models.ForeignKey(orm['users.Staff']))
        
        # Changing field 'Opinion.date'
        db.alter_column('books_opinion', 'date', models.DateTimeField(auto_now_add=True))
        
    
    
    models = {
        'books.shop': {
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'name': ('models.CharField', [], {'unique': 'True', 'max_length': '50'}),
            'url_part': ('models.CharField', [], {'unique': 'True', 'max_length': '50'})
        },
        'users.staff': {
            '_stub': True,
            'id': ('models.AutoField', [], {'primary_key': 'True'})
        },
        'books.purchaserequest': {
            'approve_man': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'approve_requests'", 'null': 'True', 'blank': 'True'}),
            'cost1': ('models.DecimalField', [], {'default': '0', 'max_digits': '10', 'decimal_places': '2', 'blank': 'True'}),
            'count': ('models.IntegerField', [], {'default': '1'}),
            'customer': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'made_requests'"}),
            'delivery_office': ('models.ForeignKey', ["orm['users.Office']"], {}),
            'executor': ('models.ForeignKey', ["orm['books.RequestExecutor']"], {}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'shop': ('models.ForeignKey', ["orm['books.Shop']"], {}),
            'state': ('models.CharField', [], {'default': "'NEW'", 'max_length': '10'}),
            'title': ('models.CharField', [], {'max_length': '255'}),
            'url': ('models.URLField', [], {'verify_exists': 'False'})
        },
        'books.bookitem': {
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'comment': ('models.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'cost': ('models.DecimalField', [], {'null': 'True', 'max_digits': '7', 'decimal_places': '2', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('models.BooleanField', [], {'default': 'True'}),
            'is_paper': ('models.BooleanField', [], {}),
            'location_staff': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'holdingbookitems'", 'null': 'True', 'blank': 'True'}),
            'location_string': ('models.CharField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'office': ('models.ForeignKey', ["orm['users.Office']"], {'null': 'True', 'blank': 'True'}),
            'owner': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': '"ownedbookitems"', 'null': 'True', 'blank': 'True'}),
            'ownership_choices': ('models.CharField', [], {'max_length': '2'}),
            'reg_date': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'registrator_staff': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'registersbook'", 'null': 'True', 'blank': 'True'}),
            'src_choices': ('models.IntegerField', [], {'default': '3'}),
            'year': ('models.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.variantbookinfo': {
            'authors': ('models.CharField', [], {'max_length': '255'}),
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'current': ('models.BooleanField', [], {'default': 'False'}),
            'description': ('models.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'image_l_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'image_m_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'image_s_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'shop_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'title': ('models.CharField', [], {'max_length': '255'})
        },
        'books.publisher': {
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'name': ('models.CharField', [], {'unique': 'True', 'max_length': '250'})
        },
        'users.office': {
            '_stub': True,
            'id': ('models.AutoField', [], {'primary_key': 'True'})
        },
        'books.requestflow': {
            'changer': ('models.ForeignKey', ["orm['users.Staff']"], {}),
            'datetime': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'request': ('models.ForeignKey', ["orm['books.PurchaseRequest']"], {}),
            'state': ('models.CharField', [], {'max_length': '10'})
        },
        'books.readhistory': {
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'book_item': ('models.ForeignKey', ["orm['books.BookItem']"], {'null': 'True', 'blank': 'True'}),
            'get_date': ('models.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'reader': ('models.ForeignKey', ["orm['users.Staff']"], {}),
            'return_date': ('models.DateTimeField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.book': {
            'authors_string': ('models.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'publisher': ('models.ForeignKey', ["orm['books.Publisher']"], {'null': 'True', 'blank': 'True'}),
            'title': ('models.CharField', [], {'max_length': '255'}),
            'years': ('models.CharField', [], {'default': "''", 'max_length': '255', 'blank': 'True'})
        },
        'books.requestexecutor': {
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'office': ('models.ForeignKey', ["orm['users.Office']"], {'null': 'True', 'blank': 'True'}),
            'staff': ('models.ForeignKey', ["orm['users.Staff']"], {})
        },
        'books.purchaseorder': {
            'created_at': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'executor': ('models.ForeignKey', ["orm['books.RequestExecutor']"], {}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'number': ('models.CharField', [], {'default': "''", 'max_length': '30', 'blank': 'True'}),
            'shop': ('models.ForeignKey', ["orm['books.Shop']"], {})
        },
        'books.opinion': {
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'date': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'reader': ('models.ForeignKey', ["orm['users.Staff']"], {}),
            'text': ('models.TextField', [], {'blank': 'True'})
        }
    }
    
    complete_apps = ['books']
