# coding: utf-8

from south.db import db
from django.db import models
from libra.books.models import *

class Migration:
    
    def forwards(self, orm):
        
        # Adding field 'BookItem.isbn'
        db.add_column('books_bookitem', 'isbn', models.DecimalField(null=True, max_digits=13, decimal_places=0, blank=True))
        
    
    
    def backwards(self, orm):
        
        # Deleting field 'BookItem.isbn'
        db.delete_column('books_bookitem', 'isbn')
        
    
    
    models = {
        'books.shop': {
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'name': ('models.CharField', [], {'unique': 'True', 'max_length': '50'}),
            'url_part': ('models.CharField', [], {'unique': 'True', 'max_length': '50'})
        },
        'books.purchaserequest': {
            'approve_man': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'approve_requests'", 'null': 'True', 'blank': 'True'}),
            'cost1': ('models.DecimalField', [], {'default': '0', 'max_digits': '10', 'decimal_places': '2', 'blank': 'True'}),
            'count': ('models.IntegerField', [], {'default': '1'}),
            'customer': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'made_requests'"}),
            'delivery_office': ('models.ForeignKey', ["orm['users.Office']"], {}),
            'executor': ('models.ForeignKey', ["orm['books.RequestExecutor']"], {}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'shop': ('models.ForeignKey', ["orm['books.Shop']"], {}),
            'state': ('models.CharField', [], {'default': "'NEW'", 'max_length': '10'}),
            'title': ('models.CharField', [], {'max_length': '255'}),
            'url': ('models.URLField', [], {'verify_exists': 'False'})
        },
        'books.readhistory': {
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'book_item': ('models.ForeignKey', ["orm['books.BookItem']"], {'null': 'True', 'blank': 'True'}),
            'get_date': ('models.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'reader': ('models.ForeignKey', ["orm['users.Staff']"], {}),
            'return_date': ('models.DateTimeField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.bookitem': {
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'comment': ('models.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'cost': ('models.DecimalField', [], {'null': 'True', 'max_digits': '7', 'decimal_places': '2', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('models.BooleanField', [], {'default': 'True'}),
            'is_paper': ('models.BooleanField', [], {}),
            'isbn': ('models.DecimalField', [], {'null': 'True', 'max_digits': '13', 'decimal_places': '0', 'blank': 'True'}),
            'location_staff': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'holdingbookitems'", 'null': 'True', 'blank': 'True'}),
            'location_string': ('models.CharField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'office': ('models.ForeignKey', ["orm['users.Office']"], {'null': 'True', 'blank': 'True'}),
            'owner': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': '"ownedbookitems"', 'null': 'True', 'blank': 'True'}),
            'ownership_choices': ('models.CharField', [], {'max_length': '2'}),
            'reg_date': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'registrator_staff': ('models.ForeignKey', ["orm['users.Staff']"], {'related_name': "'registersbook'", 'null': 'True', 'blank': 'True'}),
            'src_choices': ('models.IntegerField', [], {'default': '3'}),
            'year': ('models.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.book': {
            'authors_string': ('models.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'publisher': ('models.ForeignKey', ["orm['books.Publisher']"], {'null': 'True', 'blank': 'True'}),
            'title': ('models.CharField', [], {'max_length': '255'}),
            'years': ('models.CharField', [], {'default': "''", 'max_length': '255', 'blank': 'True'})
        },
        'books.publisher': {
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'name': ('models.CharField', [], {'unique': 'True', 'max_length': '250'})
        },
        'users.office': {
            '_stub': True,
            'id': ('models.AutoField', [], {'primary_key': 'True'})
        },
        'books.requestflow': {
            'changer': ('models.ForeignKey', ["orm['users.Staff']"], {}),
            'datetime': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'request': ('models.ForeignKey', ["orm['books.PurchaseRequest']"], {}),
            'state': ('models.CharField', [], {'max_length': '10'})
        },
        'books.purchaseorder': {
            'created_at': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'executor': ('models.ForeignKey', ["orm['books.RequestExecutor']"], {}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'number': ('models.CharField', [], {'default': "''", 'max_length': '30', 'blank': 'True'}),
            'shop': ('models.ForeignKey', ["orm['books.Shop']"], {})
        },
        'books.variantbookinfo': {
            'authors': ('models.CharField', [], {'max_length': '255'}),
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'current': ('models.BooleanField', [], {'default': 'False'}),
            'description': ('models.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'image_l_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'image_m_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'image_s_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'shop_url': ('models.URLField', [], {'default': "''", 'verify_exists': 'False', 'blank': 'True'}),
            'title': ('models.CharField', [], {'max_length': '255'})
        },
        'books.requestexecutor': {
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'office': ('models.ForeignKey', ["orm['users.Office']"], {'null': 'True', 'blank': 'True'}),
            'staff': ('models.ForeignKey', ["orm['users.Staff']"], {})
        },
        'users.staff': {
            '_stub': True,
            'id': ('models.AutoField', [], {'primary_key': 'True'})
        },
        'books.opinion': {
            'book': ('models.ForeignKey', ["orm['books.Book']"], {}),
            'date': ('models.DateTimeField', [], {'auto_now_add': 'True'}),
            'id': ('models.AutoField', [], {'primary_key': 'True'}),
            'reader': ('models.ForeignKey', ["orm['users.Staff']"], {}),
            'text': ('models.TextField', [], {'blank': 'True'})
        }
    }
    
    complete_apps = ['books']
