# coding: utf-8

from south.db import db
from django.db import models
from libra.books.models import *

class Migration:
    
    def forwards(self, orm):
        
        # Adding model 'TagCategory'
        db.create_table('books_tagcategory', (
            ('id', orm['books.tagcategory:id']),
            ('name', orm['books.tagcategory:name']),
        ))
        db.send_create_signal('books', ['TagCategory'])
        
        # Adding ManyToManyField 'TagCategory.tags'
        db.create_table('books_tagcategory_tags', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('tagcategory', models.ForeignKey(orm.TagCategory, null=False)),
            ('tag', models.ForeignKey(orm['tagging.Tag'], null=False))
        ))
        
        # Changing field 'PurchaseRequest.customer'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Staff']))
        db.alter_column('books_purchaserequest', 'customer_id', orm['books.purchaserequest:customer'])
        
        # Changing field 'PurchaseRequest.shop'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.Shop']))
        db.alter_column('books_purchaserequest', 'shop_id', orm['books.purchaserequest:shop'])
        
        # Changing field 'PurchaseRequest.url'
        # (to signature: django.db.models.fields.URLField(max_length=200))
        db.alter_column('books_purchaserequest', 'url', orm['books.purchaserequest:url'])
        
        # Changing field 'PurchaseRequest.delivery_office'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Office']))
        db.alter_column('books_purchaserequest', 'delivery_office_id', orm['books.purchaserequest:delivery_office'])
        
        # Changing field 'PurchaseRequest.executor'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.RequestExecutor']))
        db.alter_column('books_purchaserequest', 'executor_id', orm['books.purchaserequest:executor'])
        
        # Changing field 'PurchaseRequest.approve_man'
        # (to signature: django.db.models.fields.related.ForeignKey(blank=True, null=True, to=orm['users.Staff']))
        db.alter_column('books_purchaserequest', 'approve_man_id', orm['books.purchaserequest:approve_man'])
        
        # Changing field 'BookItem.office'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Office'], null=True, blank=True))
        db.alter_column('books_bookitem', 'office_id', orm['books.bookitem:office'])
        
        # Changing field 'BookItem.registrator_staff'
        # (to signature: django.db.models.fields.related.ForeignKey(blank=True, null=True, to=orm['users.Staff']))
        db.alter_column('books_bookitem', 'registrator_staff_id', orm['books.bookitem:registrator_staff'])
        
        # Changing field 'BookItem.is_active'
        # (to signature: django.db.models.fields.BooleanField(default=True, blank=True))
        db.alter_column('books_bookitem', 'is_active', orm['books.bookitem:is_active'])
        
        # Changing field 'BookItem.reg_date'
        # (to signature: django.db.models.fields.DateTimeField(auto_now_add=True, blank=True))
        db.alter_column('books_bookitem', 'reg_date', orm['books.bookitem:reg_date'])
        
        # Changing field 'BookItem.owner'
        # (to signature: django.db.models.fields.related.ForeignKey(blank=True, null=True, to=orm['users.Staff']))
        db.alter_column('books_bookitem', 'owner_id', orm['books.bookitem:owner'])
        
        # Changing field 'BookItem.is_paper'
        # (to signature: django.db.models.fields.BooleanField(default=False, blank=True))
        db.alter_column('books_bookitem', 'is_paper', orm['books.bookitem:is_paper'])
        
        # Changing field 'BookItem.location_staff'
        # (to signature: django.db.models.fields.related.ForeignKey(blank=True, null=True, to=orm['users.Staff']))
        db.alter_column('books_bookitem', 'location_staff_id', orm['books.bookitem:location_staff'])
        
        # Changing field 'BookItem.book'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.Book']))
        db.alter_column('books_bookitem', 'book_id', orm['books.bookitem:book'])
        
        # Changing field 'Book.publisher'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.Publisher'], null=True, blank=True))
        db.alter_column('books_book', 'publisher_id', orm['books.book:publisher'])
        
        # Changing field 'RequestFlow.request'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.PurchaseRequest']))
        db.alter_column('books_requestflow', 'request_id', orm['books.requestflow:request'])
        
        # Changing field 'RequestFlow.changer'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Staff']))
        db.alter_column('books_requestflow', 'changer_id', orm['books.requestflow:changer'])
        
        # Changing field 'RequestFlow.datetime'
        # (to signature: django.db.models.fields.DateTimeField(auto_now_add=True, blank=True))
        db.alter_column('books_requestflow', 'datetime', orm['books.requestflow:datetime'])
        
        # Changing field 'ReadHistory.book'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.Book']))
        db.alter_column('books_readhistory', 'book_id', orm['books.readhistory:book'])
        
        # Changing field 'ReadHistory.book_item'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.BookItem'], null=True, blank=True))
        db.alter_column('books_readhistory', 'book_item_id', orm['books.readhistory:book_item'])
        
        # Changing field 'ReadHistory.reader'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Staff']))
        db.alter_column('books_readhistory', 'reader_id', orm['books.readhistory:reader'])
        
        # Changing field 'VariantBookInfo.current'
        # (to signature: django.db.models.fields.BooleanField(default=False, blank=True))
        db.alter_column('books_variantbookinfo', 'current', orm['books.variantbookinfo:current'])
        
        # Changing field 'VariantBookInfo.shop_url'
        # (to signature: django.db.models.fields.URLField(default='', max_length=200, blank=True))
        db.alter_column('books_variantbookinfo', 'shop_url', orm['books.variantbookinfo:shop_url'])
        
        # Changing field 'VariantBookInfo.image_l_url'
        # (to signature: django.db.models.fields.URLField(default='', max_length=200, blank=True))
        db.alter_column('books_variantbookinfo', 'image_l_url', orm['books.variantbookinfo:image_l_url'])
        
        # Changing field 'VariantBookInfo.image_m_url'
        # (to signature: django.db.models.fields.URLField(default='', max_length=200, blank=True))
        db.alter_column('books_variantbookinfo', 'image_m_url', orm['books.variantbookinfo:image_m_url'])
        
        # Changing field 'VariantBookInfo.image_s_url'
        # (to signature: django.db.models.fields.URLField(default='', max_length=200, blank=True))
        db.alter_column('books_variantbookinfo', 'image_s_url', orm['books.variantbookinfo:image_s_url'])
        
        # Changing field 'VariantBookInfo.book'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.Book']))
        db.alter_column('books_variantbookinfo', 'book_id', orm['books.variantbookinfo:book'])
        
        # Changing field 'RequestExecutor.office'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Office'], null=True, blank=True))
        db.alter_column('books_requestexecutor', 'office_id', orm['books.requestexecutor:office'])
        
        # Changing field 'RequestExecutor.staff'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Staff']))
        db.alter_column('books_requestexecutor', 'staff_id', orm['books.requestexecutor:staff'])
        
        # Changing field 'PurchaseOrder.shop'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.Shop']))
        db.alter_column('books_purchaseorder', 'shop_id', orm['books.purchaseorder:shop'])
        
        # Changing field 'PurchaseOrder.created_at'
        # (to signature: django.db.models.fields.DateTimeField(auto_now_add=True, blank=True))
        db.alter_column('books_purchaseorder', 'created_at', orm['books.purchaseorder:created_at'])
        
        # Changing field 'PurchaseOrder.executor'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.RequestExecutor']))
        db.alter_column('books_purchaseorder', 'executor_id', orm['books.purchaseorder:executor'])
        
        # Changing field 'Opinion.book'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['books.Book']))
        db.alter_column('books_opinion', 'book_id', orm['books.opinion:book'])
        
        # Changing field 'Opinion.reader'
        # (to signature: django.db.models.fields.related.ForeignKey(to=orm['users.Staff']))
        db.alter_column('books_opinion', 'reader_id', orm['books.opinion:reader'])
        
        # Changing field 'Opinion.date'
        # (to signature: django.db.models.fields.DateTimeField(auto_now_add=True, blank=True))
        db.alter_column('books_opinion', 'date', orm['books.opinion:date'])
        
    
    
    def backwards(self, orm):
        
        # Deleting model 'TagCategory'
        db.delete_table('books_tagcategory')
        
        # Dropping ManyToManyField 'TagCategory.tags'
        db.delete_table('books_tagcategory_tags')
        
        # Changing field 'PurchaseRequest.customer'
        # (to signature: models.ForeignKey(orm['users.Staff']))
        db.alter_column('books_purchaserequest', 'customer_id', orm['books.purchaserequest:customer'])
        
        # Changing field 'PurchaseRequest.shop'
        # (to signature: models.ForeignKey(orm['books.Shop']))
        db.alter_column('books_purchaserequest', 'shop_id', orm['books.purchaserequest:shop'])
        
        # Changing field 'PurchaseRequest.url'
        # (to signature: models.URLField(verify_exists=False))
        db.alter_column('books_purchaserequest', 'url', orm['books.purchaserequest:url'])
        
        # Changing field 'PurchaseRequest.delivery_office'
        # (to signature: models.ForeignKey(orm['users.Office']))
        db.alter_column('books_purchaserequest', 'delivery_office_id', orm['books.purchaserequest:delivery_office'])
        
        # Changing field 'PurchaseRequest.executor'
        # (to signature: models.ForeignKey(orm['books.RequestExecutor']))
        db.alter_column('books_purchaserequest', 'executor_id', orm['books.purchaserequest:executor'])
        
        # Changing field 'PurchaseRequest.approve_man'
        # (to signature: models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        db.alter_column('books_purchaserequest', 'approve_man_id', orm['books.purchaserequest:approve_man'])
        
        # Changing field 'BookItem.office'
        # (to signature: models.ForeignKey(orm['users.Office'], null=True, blank=True))
        db.alter_column('books_bookitem', 'office_id', orm['books.bookitem:office'])
        
        # Changing field 'BookItem.registrator_staff'
        # (to signature: models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        db.alter_column('books_bookitem', 'registrator_staff_id', orm['books.bookitem:registrator_staff'])
        
        # Changing field 'BookItem.is_active'
        # (to signature: models.BooleanField(default=True))
        db.alter_column('books_bookitem', 'is_active', orm['books.bookitem:is_active'])
        
        # Changing field 'BookItem.reg_date'
        # (to signature: models.DateTimeField(auto_now_add=True))
        db.alter_column('books_bookitem', 'reg_date', orm['books.bookitem:reg_date'])
        
        # Changing field 'BookItem.owner'
        # (to signature: models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        db.alter_column('books_bookitem', 'owner_id', orm['books.bookitem:owner'])
        
        # Changing field 'BookItem.is_paper'
        # (to signature: models.BooleanField())
        db.alter_column('books_bookitem', 'is_paper', orm['books.bookitem:is_paper'])
        
        # Changing field 'BookItem.location_staff'
        # (to signature: models.ForeignKey(orm['users.Staff'], null=True, blank=True))
        db.alter_column('books_bookitem', 'location_staff_id', orm['books.bookitem:location_staff'])
        
        # Changing field 'BookItem.book'
        # (to signature: models.ForeignKey(orm['books.Book']))
        db.alter_column('books_bookitem', 'book_id', orm['books.bookitem:book'])
        
        # Changing field 'Book.publisher'
        # (to signature: models.ForeignKey(orm['books.Publisher'], null=True, blank=True))
        db.alter_column('books_book', 'publisher_id', orm['books.book:publisher'])
        
        # Changing field 'RequestFlow.request'
        # (to signature: models.ForeignKey(orm['books.PurchaseRequest']))
        db.alter_column('books_requestflow', 'request_id', orm['books.requestflow:request'])
        
        # Changing field 'RequestFlow.changer'
        # (to signature: models.ForeignKey(orm['users.Staff']))
        db.alter_column('books_requestflow', 'changer_id', orm['books.requestflow:changer'])
        
        # Changing field 'RequestFlow.datetime'
        # (to signature: models.DateTimeField(auto_now_add=True))
        db.alter_column('books_requestflow', 'datetime', orm['books.requestflow:datetime'])
        
        # Changing field 'ReadHistory.book'
        # (to signature: models.ForeignKey(orm['books.Book']))
        db.alter_column('books_readhistory', 'book_id', orm['books.readhistory:book'])
        
        # Changing field 'ReadHistory.book_item'
        # (to signature: models.ForeignKey(orm['books.BookItem'], null=True, blank=True))
        db.alter_column('books_readhistory', 'book_item_id', orm['books.readhistory:book_item'])
        
        # Changing field 'ReadHistory.reader'
        # (to signature: models.ForeignKey(orm['users.Staff']))
        db.alter_column('books_readhistory', 'reader_id', orm['books.readhistory:reader'])
        
        # Changing field 'VariantBookInfo.current'
        # (to signature: models.BooleanField(default=False))
        db.alter_column('books_variantbookinfo', 'current', orm['books.variantbookinfo:current'])
        
        # Changing field 'VariantBookInfo.shop_url'
        # (to signature: models.URLField(default='', blank=True, verify_exists=False))
        db.alter_column('books_variantbookinfo', 'shop_url', orm['books.variantbookinfo:shop_url'])
        
        # Changing field 'VariantBookInfo.image_l_url'
        # (to signature: models.URLField(default='', blank=True, verify_exists=False))
        db.alter_column('books_variantbookinfo', 'image_l_url', orm['books.variantbookinfo:image_l_url'])
        
        # Changing field 'VariantBookInfo.image_m_url'
        # (to signature: models.URLField(default='', blank=True, verify_exists=False))
        db.alter_column('books_variantbookinfo', 'image_m_url', orm['books.variantbookinfo:image_m_url'])
        
        # Changing field 'VariantBookInfo.image_s_url'
        # (to signature: models.URLField(default='', blank=True, verify_exists=False))
        db.alter_column('books_variantbookinfo', 'image_s_url', orm['books.variantbookinfo:image_s_url'])
        
        # Changing field 'VariantBookInfo.book'
        # (to signature: models.ForeignKey(orm['books.Book']))
        db.alter_column('books_variantbookinfo', 'book_id', orm['books.variantbookinfo:book'])
        
        # Changing field 'RequestExecutor.office'
        # (to signature: models.ForeignKey(orm['users.Office'], null=True, blank=True))
        db.alter_column('books_requestexecutor', 'office_id', orm['books.requestexecutor:office'])
        
        # Changing field 'RequestExecutor.staff'
        # (to signature: models.ForeignKey(orm['users.Staff']))
        db.alter_column('books_requestexecutor', 'staff_id', orm['books.requestexecutor:staff'])
        
        # Changing field 'PurchaseOrder.shop'
        # (to signature: models.ForeignKey(orm['books.Shop']))
        db.alter_column('books_purchaseorder', 'shop_id', orm['books.purchaseorder:shop'])
        
        # Changing field 'PurchaseOrder.created_at'
        # (to signature: models.DateTimeField(auto_now_add=True))
        db.alter_column('books_purchaseorder', 'created_at', orm['books.purchaseorder:created_at'])
        
        # Changing field 'PurchaseOrder.executor'
        # (to signature: models.ForeignKey(orm['books.RequestExecutor']))
        db.alter_column('books_purchaseorder', 'executor_id', orm['books.purchaseorder:executor'])
        
        # Changing field 'Opinion.book'
        # (to signature: models.ForeignKey(orm['books.Book']))
        db.alter_column('books_opinion', 'book_id', orm['books.opinion:book'])
        
        # Changing field 'Opinion.reader'
        # (to signature: models.ForeignKey(orm['users.Staff']))
        db.alter_column('books_opinion', 'reader_id', orm['books.opinion:reader'])
        
        # Changing field 'Opinion.date'
        # (to signature: models.DateTimeField(auto_now_add=True))
        db.alter_column('books_opinion', 'date', orm['books.opinion:date'])
        
    
    
    models = {
        'books.book': {
            'authors_string': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publisher': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Publisher']", 'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'years': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255', 'blank': 'True'})
        },
        'books.bookitem': {
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'cost': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '7', 'decimal_places': '2', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'is_paper': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'isbn': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '13', 'decimal_places': '0', 'blank': 'True'}),
            'location_staff': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'holdingbookitems'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'location_string': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True', 'blank': 'True'}),
            'owner': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'ownedbookitems'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'ownership_choices': ('django.db.models.fields.CharField', [], {'max_length': '2'}),
            'reg_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'registrator_staff': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'registersbook'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'src_choices': ('django.db.models.fields.IntegerField', [], {'default': '3'}),
            'year': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.opinion': {
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'text': ('django.db.models.fields.TextField', [], {'blank': 'True'})
        },
        'books.publisher': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '250', 'unique': 'True'})
        },
        'books.purchaseorder': {
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'number': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '30', 'blank': 'True'}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']"})
        },
        'books.purchaserequest': {
            'approve_man': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approve_requests'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'cost1': ('django.db.models.fields.DecimalField', [], {'default': '0', 'max_digits': '10', 'decimal_places': '2', 'blank': 'True'}),
            'count': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'customer': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'made_requests'", 'to': "orm['users.Staff']"}),
            'delivery_office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']"}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']"}),
            'state': ('django.db.models.fields.CharField', [], {'default': "'NEW'", 'max_length': '10'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'})
        },
        'books.readhistory': {
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'book_item': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookItem']", 'null': 'True', 'blank': 'True'}),
            'get_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'return_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.requestexecutor': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True', 'blank': 'True'}),
            'staff': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"})
        },
        'books.requestflow': {
            'changer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'datetime': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'request': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.PurchaseRequest']"}),
            'state': ('django.db.models.fields.CharField', [], {'max_length': '10'})
        },
        'books.shop': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True'}),
            'url_part': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True'})
        },
        'books.tagcategory': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'tags': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['tagging.Tag']"})
        },
        'books.variantbookinfo': {
            'authors': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'current': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image_l_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_m_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_s_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'shop_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'tagging.tag': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True', 'db_index': 'True'})
        },
        'users.city': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'users.department': {
            'bg_color': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'code': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'en_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'fg_color': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'children'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Department']"}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'})
        },
        'users.office': {
            'city': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.City']", 'null': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'users.staff': {
            'address': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'avatar': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'birthday': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'car': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'car_num': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True'}),
            'children': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'department': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Department']", 'null': 'True'}),
            'desk_id': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True'}),
            'domain': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'edu_date': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'edu_place': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'edu_status': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'employment': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'en_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'family_status': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'gender': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'guid': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '47', 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_big_boss': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'is_dismissed': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'join_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'login_ld': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'middle_name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True'}),
            'mobile_phone': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True'}),
            'photo': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'position': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'quit_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'wiki_name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'work_email': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'work_phone': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'db_index': 'True'})
        }
    }
    
    complete_apps = ['books']
