# coding: utf-8

from south.db import db
from django.db import models
from libra.books.models import *

class Migration:
    
    def forwards(self, orm):
        
        # Adding field 'Book.reg_date'
        db.add_column('books_book', 'reg_date', orm['books.book:reg_date'])
        
    
    
    def backwards(self, orm):
        
        # Deleting field 'Book.reg_date'
        db.delete_column('books_book', 'reg_date')
        
    
    
    models = {
        'books.book': {
            'authors_string': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publisher': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Publisher']", 'null': 'True', 'blank': 'True'}),
            'reg_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'years': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255', 'blank': 'True'})
        },
        'books.bookitem': {
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'cost': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '7', 'decimal_places': '2', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'is_paper': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'isbn': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '13', 'decimal_places': '0', 'blank': 'True'}),
            'location_staff': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'holdingbookitems'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'location_string': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True', 'blank': 'True'}),
            'owner': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'ownedbookitems'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'ownership_choices': ('django.db.models.fields.CharField', [], {'max_length': '2'}),
            'reg_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'registrator_staff': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'registersbook'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'src_choices': ('django.db.models.fields.IntegerField', [], {'default': '3'}),
            'year': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.opinion': {
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'text': ('django.db.models.fields.TextField', [], {'blank': 'True'})
        },
        'books.publisher': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '250', 'unique': 'True'})
        },
        'books.purchaseorder': {
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'number': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '30', 'blank': 'True'}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']"})
        },
        'books.purchaserequest': {
            'approve_man': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approve_requests'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'cost1': ('django.db.models.fields.DecimalField', [], {'default': '0', 'max_digits': '10', 'decimal_places': '2', 'blank': 'True'}),
            'count': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'customer': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'made_requests'", 'to': "orm['users.Staff']"}),
            'delivery_office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']"}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']"}),
            'state': ('django.db.models.fields.CharField', [], {'default': "'NEW'", 'max_length': '10'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'})
        },
        'books.readhistory': {
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'book_item': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookItem']", 'null': 'True', 'blank': 'True'}),
            'get_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'return_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.requestexecutor': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True', 'blank': 'True'}),
            'staff': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"})
        },
        'books.requestflow': {
            'changer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'datetime': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'request': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.PurchaseRequest']"}),
            'state': ('django.db.models.fields.CharField', [], {'max_length': '10'})
        },
        'books.shop': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True'}),
            'url_part': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True'})
        },
        'books.tagcategory': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'tags': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['tagging.Tag']"})
        },
        'books.variantbookinfo': {
            'authors': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'current': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image_l_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_m_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_s_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'shop_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'tagging.tag': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True', 'db_index': 'True'})
        },
        'users.city': {
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'users.department': {
            'bg_color': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'code': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'en_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'fg_color': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'children'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Department']"}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'})
        },
        'users.office': {
            'city': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.City']", 'null': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'users.staff': {
            'address': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'avatar': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'birthday': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'car': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'car_num': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True'}),
            'children': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'department': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Department']", 'null': 'True'}),
            'desk_id': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True'}),
            'domain': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'edu_date': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'edu_place': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'edu_status': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'employment': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'en_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'family_status': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'gender': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'guid': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '47', 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_big_boss': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'is_dismissed': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'join_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'login_ld': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'middle_name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True'}),
            'mobile_phone': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True'}),
            'photo': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'position': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'quit_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'wiki_name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'work_email': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'work_phone': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'db_index': 'True'})
        }
    }
    
    complete_apps = ['books']
