# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models

class Migration(SchemaMigration):

    def forwards(self, orm):
        
        # Adding field 'BookItem.shelf'
        db.add_column('books_bookitem', 'shelf', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True), keep_default=False)

        # Adding field 'BookItem.case'
        db.add_column('books_bookitem', 'case', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True), keep_default=False)

        # Adding field 'Book.shelf'
        db.add_column('books_book', 'shelf', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True), keep_default=False)

        # Adding field 'Book.case'
        db.add_column('books_book', 'case', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True), keep_default=False)


    def backwards(self, orm):
        
        # Deleting field 'BookItem.shelf'
        db.delete_column('books_bookitem', 'shelf')

        # Deleting field 'BookItem.case'
        db.delete_column('books_bookitem', 'case')

        # Deleting field 'Book.shelf'
        db.delete_column('books_book', 'shelf')

        # Deleting field 'Book.case'
        db.delete_column('books_book', 'case')


    models = {
        'books.book': {
            'Meta': {'object_name': 'Book'},
            'authors_string': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'case': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_cover': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookCover']", 'null': 'True', 'blank': 'True'}),
            'publisher': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Publisher']", 'null': 'True', 'blank': 'True'}),
            'reg_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'shelf': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'years': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255', 'blank': 'True'})
        },
        'books.bookcover': {
            'Meta': {'object_name': 'BookCover'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'img_large': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'})
        },
        'books.bookitem': {
            'Meta': {'object_name': 'BookItem'},
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'case': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'cost': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '7', 'decimal_places': '2', 'blank': 'True'}),
            'cover': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookCover']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'is_paper': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'isbn': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '13', 'decimal_places': '0', 'blank': 'True'}),
            'location_staff': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'holdingbookitems'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'location_string': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True', 'blank': 'True'}),
            'owner': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'ownedbookitems'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'ownership_choices': ('django.db.models.fields.CharField', [], {'max_length': '2'}),
            'reg_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'registrator_staff': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'registersbook'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'rfid': ('libra.books.models.RfidField', [], {'max_length': '12', 'null': 'True', 'blank': 'True'}),
            'shelf': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'src_choices': ('django.db.models.fields.IntegerField', [], {'default': '3'}),
            'year': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.opinion': {
            'Meta': {'object_name': 'Opinion'},
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'text': ('django.db.models.fields.TextField', [], {'blank': 'True'})
        },
        'books.publisher': {
            'Meta': {'object_name': 'Publisher'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '250', 'unique': 'True'})
        },
        'books.purchaseorder': {
            'Meta': {'object_name': 'PurchaseOrder'},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'number': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '30', 'blank': 'True'}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']"})
        },
        'books.purchaserequest': {
            'Meta': {'object_name': 'PurchaseRequest'},
            'approve_man': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approve_requests'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Staff']"}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'customer': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'made_requests'", 'to': "orm['users.Staff']"}),
            'delivery_office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']"}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'state': ('django.db.models.fields.CharField', [], {'default': "'NEW'", 'max_length': '10'})
        },
        'books.purchaserequestonebook': {
            'Meta': {'object_name': 'PurchaseRequestOneBook'},
            'comment': ('django.db.models.fields.TextField', [], {'default': "u''"}),
            'cost1': ('django.db.models.fields.DecimalField', [], {'default': '0', 'max_digits': '10', 'decimal_places': '2', 'blank': 'True'}),
            'count': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'request': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'requested_books'", 'to': "orm['books.PurchaseRequest']"}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']", 'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'})
        },
        'books.readhistory': {
            'Meta': {'object_name': 'ReadHistory'},
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'book_item': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookItem']", 'null': 'True', 'blank': 'True'}),
            'get_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'return_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.requestexecutor': {
            'Meta': {'object_name': 'RequestExecutor'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True', 'blank': 'True'}),
            'staff': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"})
        },
        'books.requestflow': {
            'Meta': {'object_name': 'RequestFlow'},
            'changer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Staff']"}),
            'datetime': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'request': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.PurchaseRequest']"}),
            'state': ('django.db.models.fields.CharField', [], {'max_length': '15'})
        },
        'books.shop': {
            'Meta': {'object_name': 'Shop'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True'}),
            'url_part': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True'})
        },
        'books.tagcategory': {
            'Meta': {'object_name': 'TagCategory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'tags': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'tagcategory'", 'symmetrical': 'False', 'to': "orm['tagging.Tag']"})
        },
        'books.variantbookinfo': {
            'Meta': {'object_name': 'VariantBookInfo'},
            'asin': ('django.db.models.fields.CharField', [], {'max_length': '15', 'null': 'True', 'blank': 'True'}),
            'authors': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'current': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image_l_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_m_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_s_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'shop_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'tagging.tag': {
            'Meta': {'object_name': 'Tag'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'unique': 'True', 'db_index': 'True'})
        },
        'users.city': {
            'Meta': {'object_name': 'City'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'users.department': {
            'Meta': {'object_name': 'Department'},
            'bg_color': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'code': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'en_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'fg_color': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'children'", 'blank': 'True', 'null': 'True', 'to': "orm['users.Department']"}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'})
        },
        'users.office': {
            'Meta': {'object_name': 'Office'},
            'city': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.City']", 'null': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'users.staff': {
            'Meta': {'object_name': 'Staff'},
            'address': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'avatar': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'birthday': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'car': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'car_num': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True'}),
            'children': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'department': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Department']", 'null': 'True'}),
            'desk_id': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True'}),
            'domain': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'edu_date': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'edu_place': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'edu_status': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'employment': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'en_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True'}),
            'family_status': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'gender': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'guid': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '47', 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_big_boss': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'is_dismissed': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'join_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'login_ld': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'db_index': 'True'}),
            'middle_name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True'}),
            'mobile_phone': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']", 'null': 'True'}),
            'photo': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'position': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'quit_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'wiki_name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'work_email': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'work_phone': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'db_index': 'True'})
        }
    }

    complete_apps = ['books']
