# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models

class Migration(SchemaMigration):
    
    def forwards(self, orm):
        
        # Adding model 'BookQueue'
        db.create_table('books_bookqueue', (
            ('finished_at', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('created_at', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('finished', self.gf('django.db.models.fields.BooleanField')(default=False, blank=True)),
            ('book', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['books.Book'])),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['django_intranet_stuff.Staff'])),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
        ))
        db.send_create_signal('books', ['BookQueue'])
    
    
    def backwards(self, orm):
        
        # Deleting model 'BookQueue'
        db.delete_table('books_bookqueue')
    
    
    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime(2014, 8, 27, 16, 1, 11, 958733)'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime(2014, 8, 27, 16, 1, 11, 958634)'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'books.book': {
            'Meta': {'object_name': 'Book'},
            'at_id': ('django.db.models.fields.IntegerField', [], {'null': 'True'}),
            'authors_string': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'case': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_cover': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookCover']", 'null': 'True', 'blank': 'True'}),
            'mulca_file': ('django.db.models.fields.files.FileField', [], {'max_length': '255', 'blank': 'True'}),
            'publisher': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Publisher']", 'null': 'True', 'blank': 'True'}),
            'reg_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'remove_the_file': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'shelf': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'years': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255', 'blank': 'True'})
        },
        'books.bookcover': {
            'Meta': {'object_name': 'BookCover'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'img_large': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'})
        },
        'books.bookitem': {
            'Meta': {'object_name': 'BookItem'},
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'case': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'cost': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '7', 'decimal_places': '2', 'blank': 'True'}),
            'cover': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookCover']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'is_paper': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'is_tablebook': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'isbn': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '13', 'decimal_places': '0', 'blank': 'True'}),
            'location_staff': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'holdingbookitems'", 'null': 'True', 'to': "orm['django_intranet_stuff.Staff']"}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Office']", 'null': 'True', 'blank': 'True'}),
            'owner': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'ownedbookitems'", 'null': 'True', 'to': "orm['django_intranet_stuff.Staff']"}),
            'ownership_choices': ('django.db.models.fields.CharField', [], {'max_length': '2'}),
            'reg_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'registrator_staff': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'registersbook'", 'null': 'True', 'to': "orm['django_intranet_stuff.Staff']"}),
            'rfid': ('libra.books.models.RfidField', [], {'max_length': '12', 'null': 'True', 'blank': 'True'}),
            'shelf': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'src_choices': ('django.db.models.fields.IntegerField', [], {'default': '3'}),
            'year': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.bookqueue': {
            'Meta': {'object_name': 'BookQueue'},
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'finished': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'finished_at': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"})
        },
        'books.opinion': {
            'Meta': {'object_name': 'Opinion'},
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"}),
            'text': ('django.db.models.fields.TextField', [], {'blank': 'True'})
        },
        'books.publisher': {
            'Meta': {'object_name': 'Publisher'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '250'})
        },
        'books.purchaseorder': {
            'Meta': {'object_name': 'PurchaseOrder'},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'number': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '30', 'blank': 'True'}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']"})
        },
        'books.purchaserequest': {
            'Meta': {'object_name': 'PurchaseRequest'},
            'approve_man': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'approve_requests'", 'null': 'True', 'to': "orm['django_intranet_stuff.Staff']"}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'customer': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'made_requests'", 'to': "orm['django_intranet_stuff.Staff']"}),
            'delivery_office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Office']"}),
            'executor': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.RequestExecutor']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'state': ('django.db.models.fields.CharField', [], {'default': "'NEW'", 'max_length': '10'})
        },
        'books.purchaserequestonebook': {
            'Meta': {'object_name': 'PurchaseRequestOneBook'},
            'approved': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'comment': ('django.db.models.fields.TextField', [], {'default': "u''"}),
            'cost1': ('django.db.models.fields.DecimalField', [], {'default': '0', 'max_digits': '10', 'decimal_places': '2', 'blank': 'True'}),
            'count': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'request': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'requested_books'", 'to': "orm['books.PurchaseRequest']"}),
            'shop': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Shop']", 'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'})
        },
        'books.readhistory': {
            'Meta': {'object_name': 'ReadHistory'},
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'book_item': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.BookItem']", 'null': 'True', 'blank': 'True'}),
            'get_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'reader': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"}),
            'return_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'})
        },
        'books.reportemail': {
            'Meta': {'object_name': 'ReportEmail'},
            'email': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'books.requestexecutor': {
            'Meta': {'object_name': 'RequestExecutor'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Office']", 'null': 'True', 'blank': 'True'}),
            'staff': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"})
        },
        'books.requestflow': {
            'Meta': {'object_name': 'RequestFlow'},
            'changer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"}),
            'datetime': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'request': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.PurchaseRequest']"}),
            'state': ('django.db.models.fields.CharField', [], {'max_length': '15'})
        },
        'books.shop': {
            'Meta': {'object_name': 'Shop'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50'}),
            'url_part': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50'})
        },
        'books.tagcategory': {
            'Meta': {'object_name': 'TagCategory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'tags': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'tagcategory'", 'symmetrical': 'False', 'to': "orm['tagging.Tag']"})
        },
        'books.variantbookinfo': {
            'Meta': {'object_name': 'VariantBookInfo'},
            'asin': ('django.db.models.fields.CharField', [], {'max_length': '15', 'null': 'True', 'blank': 'True'}),
            'authors': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'book': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['books.Book']"}),
            'current': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image_l_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_m_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'image_s_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'shop_url': ('django.db.models.fields.URLField', [], {'default': "''", 'max_length': '200', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'contenttypes.contenttype': {
            'Meta': {'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'django_intranet_stuff.city': {
            'Meta': {'object_name': 'City', 'db_table': "'intranet_city'"},
            'color': ('django.db.models.fields.CharField', [], {'default': "'000000'", 'max_length': '6'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'blank': 'True'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'})
        },
        'django_intranet_stuff.department': {
            'Meta': {'object_name': 'Department', 'db_table': "'intranet_department'"},
            'bg_color': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'description': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'description_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'en_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'fg_color': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'jira_project': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'maillists': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['django_intranet_stuff.Department']"}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'short_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'short_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'url': ('django.db.models.fields.CharField', [], {'default': "''", 'unique': 'True', 'max_length': '255'}),
            'wiki_page': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'})
        },
        'django_intranet_stuff.office': {
            'Meta': {'object_name': 'Office', 'db_table': "'intranet_office'"},
            'address1': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address1_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address2': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address2_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'city': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.City']", 'null': 'True', 'blank': 'True'}),
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'color': ('django.db.models.fields.CharField', [], {'max_length': '10'}),
            'coord_x': ('django.db.models.fields.FloatField', [], {'null': 'True'}),
            'coord_y': ('django.db.models.fields.FloatField', [], {'null': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'fax': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'have_map': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'phone': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'tz': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'zoom': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'})
        },
        'django_intranet_stuff.staff': {
            'Meta': {'object_name': 'Staff', 'db_table': "'intranet_staff'"},
            'address': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'affiliation': ('django.db.models.fields.CharField', [], {'max_length': '32', 'db_index': 'True'}),
            'birthday': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'car': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'}),
            'car_num': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'department': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Department']", 'null': 'True'}),
            'domain': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '1'}),
            'employment': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '1'}),
            'en_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'first_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'first_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0', 'db_index': 'True'}),
            'gender': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '1'}),
            'guid': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '47', 'null': 'True'}),
            'hide_birthday_year': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'hide_middle_name': ('django.db.models.fields.BooleanField', [], {'default': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'is_big_boss': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'is_dismissed': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'is_homeworker': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'is_robot': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'blank': 'True'}),
            'join_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'last_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'last_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'login_ld': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50', 'db_index': 'True'}),
            'login_mail': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'middle_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'mobile_phone': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'normal_login': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Office']", 'null': 'True'}),
            'position': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '150'}),
            'position_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '150'}),
            'quit_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'tz': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '30'}),
            'uid': ('django.db.models.fields.CharField', [], {'max_length': '16', 'unique': 'True', 'null': 'True', 'db_index': 'True'}),
            'user': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['auth.User']", 'unique': 'True', 'null': 'True'}),
            'wiki_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'work_email': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'work_phone': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'db_index': 'True'})
        },
        'tagging.tag': {
            'Meta': {'object_name': 'Tag'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50', 'db_index': 'True'})
        }
    }
    
    complete_apps = ['books', 'books']
