# coding: utf-8

from django.contrib.syndication.views import Feed, FeedDoesNotExist
from libra.books.models import Book, BookItem

class LatestBooksRSS(Feed):
    u'Общий класс для вывода лент новых книг'
    title_template = 'feeds/latest-books-title.html'
    description_template = 'feeds/latest-books-description.html'
    
    qfilter = {'is_active': True}   # Фильтр экземпляров книг по умолчанию
    
    def item_link(self, obj):
        return obj.book.get_absolute_url()
    
    def item_author_name(self, item):
        return item.registrator_staff
    
    def item_author_email(self, obj):
        return obj.registrator_staff.work_email
    
    def item_pubdate(self, obj):
        return obj.reg_date

    def items(self):
        return BookItem.objects.select_related('book').filter(**self.qfilter).order_by('-reg_date','book__title')[:50]

class LatestCompanyBooksRSS(LatestBooksRSS):
    u'Показывает ленту добавленных книг, которые принадлежат компании'
    
    title = u'Новые книги Яндекса'
    link = '/rss/latest-ya'
    description = u'Новые книги, купленные компанией'

    qfilter = {
        'is_active': True,
        'ownership_choices': 'YA',
    }

class LatestAllBooksRSS(LatestBooksRSS):
    u'Показывает ленту всех новых книг'
    
    title = u'Все новые книги'
    link = '/rss/latest-all'
    description = u'Новые книги, добавленные в библиотеку'

# Перечень RSS-потоков, который выставляется наружу (используется в urls.py)
feeds = {
    'latest-all': LatestAllBooksRSS,
    'latest-ya': LatestCompanyBooksRSS,
}
