# -*- coding: utf-8 -*-

from libra.books.models import BookItem, Office

class LostBooks(object):

    def data(self):
        office_id = Office.objects.filter(name__contains='Морозов')[0].id
        for book_item in BookItem.objects.select_related('book').filter(
            office__id=office_id,
            location_staff=None,
            shelf__isnull=True
        ):
            yield {'book': book_item.book,
                   'book_item': book_item,
                   'rfid': book_item.rfid,
                   'title': book_item.book.title,
                   'reg_date': book_item.reg_date,
                   'cost': book_item.cost,
                   'last_reader': self.last_reader(book_item)}
        

    def last_reader(self, book_item):
        s = book_item.readhistory_set
        hist = s.latest('id') if s.exists() else None
        return hist.reader if hist else None
