
from libra.books.models import PurchaseRequestOneBook
from datetime import datetime, timedelta

class Orders(object):

    def data(self):
        week_ago = datetime.now() - timedelta(days=7)
        books = PurchaseRequestOneBook.objects.select_related('request', 'request__customer')\
            .filter(request__created_at__gt=week_ago)
        for book in books:
            yield {'department': self.department(book.request.customer),
                   'user': book.request.customer,
                   'title': book.title,
                   'cost': book.cost1,
                   'count': book.count}

    def department(self, user):
        depts = user.departments
        if len(depts) > 1:
            return depts[1].name
        return "Unknown"

