
from libra.books.models import ReadHistory
from datetime import datetime, timedelta
from django.conf import settings

class Returns(object):

    def data(self):
        week_ago = datetime.now() - timedelta(days=7)
        interval = datetime.now() + settings.BOOK_HOLD_PERIOD
        history = ReadHistory.objects.select_related('reader', 'book')\
            .filter(return_date__gt=week_ago,
                    get_date__lte=interval,
                    get_date__gte=settings.DATE_BUGFIX_RELEASE)
        for record in history:
            yield {'reader': record.reader,
                   'book': record.book,
                   'title': record.book.title,
                   'taken': record.get_date,
                   'returned': record.return_date}
