# coding: utf-8
from django_mds.storage import MDSStorage
from django_elliptics.storage import EllipticsStorage
from urlparse import urlsplit

def is_elliptics_name(name):
    """
    В MDS ключи начинаются строго с числа, в Elliptics всегда не с числа.
    Поэтому мы можем явно сказать, что если name начинается не с числа, то
    файла лежит в Elliptics.
    """
    return not name.split('/')[0].isdigit()


class EllipticsMDSStorage(MDSStorage):
    """
    Пишем только в MDS, а читаем в зависимости от name
    """
    def __init__(self, *args, **kwargs):
        self.elliptics_storage = EllipticsStorage(*args, **kwargs)
        super(EllipticsMDSStorage, self).__init__(*args, **kwargs)

    def exists(self, name):
        if is_elliptics_name(name):
            return self.elliptics_storage.exists(name)
        return super(EllipticsMDSStorage, self).exists(name)

    def url(self, name):
        if is_elliptics_name(name):
            return self.elliptics_storage.url(name)
        full_url = super(EllipticsMDSStorage, self).url(name)
        return "/mds" + urlsplit(full_url).path

    def open(self, name, mode='rb'):
        if is_elliptics_name(name):
            return self.elliptics_storage.open(name, mode)
        return super(EllipticsMDSStorage, self).open(name, mode)

    def size(self, name):
        if is_elliptics_name(name):
            return self.elliptics_storage.size(name)
        return super(EllipticsMDSStorage, self).size(name)
