# -*- coding: utf8 -*-
from django import template
from django.template import Context
from django.template.loader import get_template
from django.core.cache import cache

from libra.books.utils import alpha_letters

register = template.Library()




@register.simple_tag
def alphabet_navigator(current_letter=None):
    ''' Отображает алфавитный указатель (первые буквы-ссылки) '''
    
    first_letters = alpha_letters()
    
    tpl = get_template('components/alphabet-letters.html')
    return tpl.render(Context({'first_letters': first_letters }))