# -*- coding: utf8 -*-
from django import template
from django.template import Context
from django.template.loader import get_template

register = template.Library()


@register.simple_tag
def b_book_index(book, cover_size, book_index):
    ''' Блок книги на морде в блоке трех книг
        cover_size: s, m или пустая строка - суффикс к классу обложки
        book_index: 1,2,3 - показывает на расположение книги в трешке последних книг
    '''
    tpl = get_template('components/b-book-index.html')
    return tpl.render(Context({'book': book, "cover_size": cover_size, "book_index":book_index }))
