# -*- coding: utf8 -*-
from django import template
from django.template import Context
from django.template.loader import get_template
from libra.books.models import Book, BookItem
from django.db.models import Count 

register = template.Library()

@register.simple_tag
def total_book_counters():
    ''' Показывает количество книг в библиотеке '''
    
    books = Book.objects.filter(bookitem__is_active=True).aggregate(_count=Count('id', distinct=True))
    bookitems = BookItem.objects.filter(is_active=True).aggregate(_count=Count('id'))
    
    tpl = get_template('components/book-counters.html')
    return tpl.render(Context({'books': books['_count'], 'bookitems':bookitems['_count'] }))
